/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractResponseExtractorProvider
implements ResponseExtractorProvider {
    private final RequestType requestType;

    protected AbstractResponseExtractorProvider(RequestType requestType) {
        this.requestType = requestType;
    }

    @Override
    public boolean support(MethodMeta method) {
        return this.requestType == method.getRequestType();
    }

    @Override
    public ResponseExtractor<?> getResponseExtractor(MethodMeta meta) {
        Method method = (Method)meta.getElement();
        boolean wrapped = this.isWrapped(meta);
        GenericType genericType = wrapped ? GenericType.forMethod(method).returnType().resolveType(0) : GenericType.forMethod(method).returnType();
        ResponseExtractor<?> extractor = this.getResponseExtractor(meta, genericType);
        if (extractor == null) {
            throw new UnsupportedOperationException("can not find response extractor for " + meta);
        }
        return extractor;
    }

    private boolean isWrapped(MethodMeta meta) {
        Class<?> returnType = meta.getReturnType();
        return CompletableFuture.class == returnType || Optional.class == returnType;
    }

    protected abstract ResponseExtractor<?> getResponseExtractor(MethodMeta var1, GenericType var2);
}

