/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.executor;

import io.manbang.ebatis.core.executor.AbstractRequestExecutor;
import io.manbang.ebatis.core.request.RequestFactory;
import io.manbang.ebatis.core.session.ClusterSession;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchScrollRequest;

class SearchScrollRequestExecutor
extends AbstractRequestExecutor<ActionRequest> {
    static final SearchScrollRequestExecutor INSTANCE = new SearchScrollRequestExecutor();

    private SearchScrollRequestExecutor() {
    }

    @Override
    protected AbstractRequestExecutor.RequestAction<ActionRequest> getRequestAction(ClusterSession session) {
        return (request, extractor) -> {
            if (request instanceof SearchRequest) {
                return session.searchAsync((SearchRequest)request, extractor);
            }
            if (request instanceof SearchScrollRequest) {
                return session.scrollAsync((SearchScrollRequest)request, extractor);
            }
            if (request instanceof ClearScrollRequest) {
                return session.clearScrollAsync((ClearScrollRequest)request, extractor);
            }
            return CompletableFuture.completedFuture(null);
        };
    }

    @Override
    protected RequestFactory<ActionRequest> getRequestFactory() {
        return RequestFactory.searchScroll();
    }
}

