/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.domain.Pageable;
import java.util.Collections;
import java.util.List;

public class PageImpl<T>
implements Page<T> {
    private final long total;
    private final List<T> content;
    private final Pageable pageable;
    private final int totalPage;

    public PageImpl(long total, List<T> content, Pageable pageable) {
        this.total = total;
        this.content = Collections.unmodifiableList(content);
        this.pageable = pageable;
        this.totalPage = total % (long)pageable.getSize() == 0L ? (int)(total / (long)pageable.getSize()) : (int)(total / (long)pageable.getSize() + 1L);
    }

    @Override
    public int getTotalPage() {
        return this.totalPage;
    }

    @Override
    public long getTotal() {
        return this.total;
    }

    @Override
    public Pageable getPageable() {
        return this.pageable;
    }

    @Override
    public List<T> getContent() {
        return this.content;
    }
}

