/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;

public class ResponseExtractorLoader {
    private static final Map<MethodMeta, ResponseExtractor<?>> RESPONSE_EXTRACTORS = new HashMap();
    private static final List<ResponseExtractorProvider> RESPONSE_EXTRACTOR_PROVIDERS = new ArrayList<ResponseExtractorProvider>();

    private ResponseExtractorLoader() {
        throw new UnsupportedOperationException();
    }

    public static ResponseExtractor<?> getResponseExtractor(MethodMeta method) {
        return RESPONSE_EXTRACTORS.computeIfAbsent(method, ResponseExtractorLoader::findResponseExtractor);
    }

    private static ResponseExtractor<?> findResponseExtractor(MethodMeta method) {
        for (ResponseExtractorProvider provider : RESPONSE_EXTRACTOR_PROVIDERS) {
            if (!provider.support(method)) continue;
            return provider.getResponseExtractor(method);
        }
        throw new UnsupportedOperationException("\u627e\u4e0d\u5230\u54cd\u5e94\u63d0\u53d6\u5668");
    }

    static {
        ServiceLoader.load(ResponseExtractorProvider.class).forEach(RESPONSE_EXTRACTOR_PROVIDERS::add);
        Collections.sort(RESPONSE_EXTRACTOR_PROVIDERS);
    }
}

