/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.proxy;

import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.cluster.ClusterRouter;
import io.manbang.ebatis.core.cluster.ClusterRouterLoader;
import io.manbang.ebatis.core.common.MethodUtils;
import io.manbang.ebatis.core.config.Env;
import io.manbang.ebatis.core.domain.ContextHolder;
import io.manbang.ebatis.core.meta.MapperInterface;
import io.manbang.ebatis.core.meta.MapperMethod;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;

class MapperProxy
implements InvocationHandler {
    private final MapperInterface mapperInterface;
    private final String clusterRouterName;
    private final LazyInitializer<ClusterRouter> clusterRouter;

    MapperProxy(Class<?> mapperType, String name) {
        this.mapperInterface = MapperInterface.of(mapperType);
        this.clusterRouterName = this.getClusterRouterName(name);
        this.clusterRouter = new LazyInitializer<ClusterRouter>(){

            protected ClusterRouter initialize() {
                return ClusterRouterLoader.getClusterRouter(MapperProxy.this.clusterRouterName);
            }
        };
    }

    private String getClusterRouterName(String name) {
        if (StringUtils.isNotBlank((CharSequence)name)) {
            return name;
        }
        String n = this.mapperInterface.getClusterRouterName();
        if (StringUtils.isNotBlank((CharSequence)n)) {
            return n;
        }
        return Env.getClusterRouterName();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws ConcurrentException {
        if (MethodUtils.isObjectMethod(method)) {
            return this.invokeObjectMethod(method, args);
        }
        MapperMethod mapperMethod = this.mapperInterface.getMapperMethod(method);
        ContextHolder.setHttpConfig(mapperMethod.getHttpConfig());
        Cluster cluster = ((ClusterRouter)this.clusterRouter.get()).route(mapperMethod);
        return mapperMethod.invoke(cluster, args);
    }

    private Object invokeObjectMethod(Method method, Object[] args) {
        if (MethodUtils.isToStringMethod(method)) {
            return this.mapperInterface.toString();
        }
        if (MethodUtils.isHashCodeMethod(method)) {
            return this.mapperInterface.hashCode();
        }
        if (MethodUtils.isEqualsMethod(method)) {
            return this.mapperInterface.equals(args[0]);
        }
        return null;
    }
}

