/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.common.ObjectMapperHolder;
import io.manbang.ebatis.core.exception.DocumentDeserializeException;
import io.manbang.ebatis.core.response.MultiGetResponseExtractor;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;

public class ArrayMultiGetResponseExtractor<T>
implements MultiGetResponseExtractor<T[]> {
    private static final Map<Class<?>, ArrayMultiGetResponseExtractor<?>> MAPPERS = new ConcurrentHashMap();
    private final Class<T> entityClass;

    public static <T> ArrayMultiGetResponseExtractor<T> of(Class<T> entityClass) {
        return MAPPERS.computeIfAbsent(entityClass, ArrayMultiGetResponseExtractor::new);
    }

    private ArrayMultiGetResponseExtractor(Class<T> entityClass) {
        this.entityClass = entityClass;
    }

    @Override
    public T[] doExtractData(MultiGetResponse response) {
        MultiGetItemResponse[] responses = response.getResponses();
        Object[] result = (Object[])Array.newInstance(this.entityClass, responses.length);
        for (int i = 0; i < responses.length; ++i) {
            try {
                if (!responses[i].getResponse().isExists()) continue;
                result[i] = ObjectMapperHolder.objectMapper().readValue(responses[i].getResponse().getSourceAsBytes(), this.entityClass);
                continue;
            }
            catch (IOException e) {
                throw new DocumentDeserializeException(e);
            }
        }
        return result;
    }
}

