/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.proxy;

import io.manbang.ebatis.core.cluster.ClusterRouter;
import io.manbang.ebatis.core.domain.Context;
import io.manbang.ebatis.core.domain.ContextHolder;
import io.manbang.ebatis.core.domain.HttpConfig;
import io.manbang.ebatis.core.exception.EbatisException;
import io.manbang.ebatis.core.interceptor.DefaultPostResponseInfo;
import io.manbang.ebatis.core.interceptor.Interceptor;
import io.manbang.ebatis.core.interceptor.InterceptorFactory;
import io.manbang.ebatis.core.mapper.IndexApi;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.ParameterMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.meta.ResultType;
import io.manbang.ebatis.core.response.ResponseExtractor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.Requests;
import org.elasticsearch.client.indices.CreateIndexRequest;
import org.elasticsearch.client.indices.CreateIndexResponse;

class IndexApiImpl
implements IndexApi {
    private static final Interceptor INTERCEPTOR = InterceptorFactory.interceptors();
    private final LazyInitializer<ClusterRouter> clusterRouter;

    IndexApiImpl(LazyInitializer<ClusterRouter> clusterRouter) {
        this.clusterRouter = clusterRouter;
    }

    public static IndexApi index(LazyInitializer<ClusterRouter> clusterRouter) {
        return new IndexApiImpl(clusterRouter);
    }

    @Override
    public RefreshResponse refresh(String ... indices) {
        return this.refreshAsync(indices).join();
    }

    @Override
    public CompletableFuture<RefreshResponse> refreshAsync(String ... indices) {
        CompletableFuture<RefreshResponse> future = new CompletableFuture<RefreshResponse>();
        Context context = ContextHolder.getContext();
        RefreshRequest refreshRequest = Requests.refreshRequest((String[])indices);
        try {
            ((ClusterRouter)this.clusterRouter.get()).route(this.getMethodMeta(indices)).highLevelClient().indices().refreshAsync(refreshRequest, RequestOptions.DEFAULT, ActionListener.wrap(response -> {
                ContextHolder.setContext(context);
                try {
                    future.complete((RefreshResponse)response);
                    INTERCEPTOR.postResponse(new DefaultPostResponseInfo<RefreshRequest, RefreshResponse>(refreshRequest, (RefreshResponse)response));
                }
                finally {
                    ContextHolder.remove();
                }
            }, exception -> {
                future.completeExceptionally((Throwable)exception);
                INTERCEPTOR.handleException((Throwable)exception);
                ContextHolder.remove();
            }));
        }
        catch (ConcurrentException e) {
            throw new EbatisException(e);
        }
        return future;
    }

    @Override
    public CreateIndexResponse create(String index, Map settings, Map source) {
        return this.createAsync(index, settings, source).join();
    }

    @Override
    public CompletableFuture<CreateIndexResponse> createAsync(String index, Map settings, Map source) {
        CompletableFuture<CreateIndexResponse> future = new CompletableFuture<CreateIndexResponse>();
        Context context = ContextHolder.getContext();
        final CreateIndexRequest createIndexRequest = new CreateIndexRequest(index);
        createIndexRequest.settings(settings);
        createIndexRequest.mapping(source);
        try {
            ((ClusterRouter)this.clusterRouter.get()).route(this.getMethodMeta(new String[]{index})).highLevelClient().indices().createAsync(createIndexRequest, RequestOptions.DEFAULT, ActionListener.wrap(response -> {
                ContextHolder.setContext(context);
                try {
                    future.complete((CreateIndexResponse)response);
                    INTERCEPTOR.postResponse(new DefaultPostResponseInfo<1, CreateIndexResponse>(new ActionRequest(){

                        public ActionRequestValidationException validate() {
                            return null;
                        }

                        public CreateIndexRequest createIndexRequest() {
                            return createIndexRequest;
                        }
                    }, (CreateIndexResponse)response));
                }
                finally {
                    ContextHolder.remove();
                }
            }, exception -> {
                future.completeExceptionally((Throwable)exception);
                INTERCEPTOR.handleException((Throwable)exception);
                ContextHolder.remove();
            }));
        }
        catch (ConcurrentException e) {
            throw new EbatisException(e);
        }
        return future;
    }

    @Override
    public AcknowledgedResponse delete(String ... indices) {
        return this.deleteAsync(indices).join();
    }

    @Override
    public CompletableFuture<AcknowledgedResponse> deleteAsync(String ... indices) {
        CompletableFuture<AcknowledgedResponse> future = new CompletableFuture<AcknowledgedResponse>();
        Context context = ContextHolder.getContext();
        DeleteIndexRequest deleteIndexRequest = new DeleteIndexRequest(indices);
        try {
            ((ClusterRouter)this.clusterRouter.get()).route(this.getMethodMeta(indices)).highLevelClient().indices().deleteAsync(deleteIndexRequest, RequestOptions.DEFAULT, ActionListener.wrap(response -> {
                ContextHolder.setContext(context);
                try {
                    future.complete((AcknowledgedResponse)response);
                    INTERCEPTOR.postResponse(new DefaultPostResponseInfo<DeleteIndexRequest, AcknowledgedResponse>(deleteIndexRequest, (AcknowledgedResponse)response));
                }
                finally {
                    ContextHolder.remove();
                }
            }, exception -> {
                future.completeExceptionally((Throwable)exception);
                INTERCEPTOR.handleException((Throwable)exception);
                ContextHolder.remove();
            }));
        }
        catch (ConcurrentException e) {
            throw new EbatisException(e);
        }
        return future;
    }

    private MethodMeta getMethodMeta(final String[] indices) {
        return new MethodMeta(){

            @Override
            public Class<?> getReturnType() {
                return null;
            }

            @Override
            public Optional<Class<?>> unwrappedReturnType() {
                return Optional.empty();
            }

            @Override
            public String[] getIndices(MethodMeta meta, Object[] args) {
                return indices;
            }

            @Override
            public String[] getTypes(MethodMeta meta, Object[] args) {
                return new String[0];
            }

            @Override
            public RequestType getRequestType() {
                return null;
            }

            @Override
            public ResultType getResultType() {
                return null;
            }

            @Override
            public <A extends Annotation> A getRequestAnnotation() {
                return null;
            }

            @Override
            public HttpConfig getHttpConfig() {
                return null;
            }

            @Override
            public List<ParameterMeta> getParameterMetas() {
                return Collections.emptyList();
            }

            @Override
            public ParameterMeta getConditionParameter() {
                return null;
            }

            @Override
            public Optional<ParameterMeta> findConditionParameter() {
                return Optional.empty();
            }

            @Override
            public Optional<ParameterMeta> getPageableParameter() {
                return Optional.empty();
            }

            @Override
            public ParameterMeta getResponseExtractorParameter() {
                return null;
            }

            @Override
            public String[] getIncludeFields() {
                return new String[0];
            }

            @Override
            public ResponseExtractor<?> getResponseExtractor(Object[] args) {
                return null;
            }

            @Override
            public Method getElement() {
                return null;
            }
        };
    }
}

