/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.request;

import io.manbang.ebatis.core.annotation.Bulk;
import io.manbang.ebatis.core.annotation.BulkType;
import io.manbang.ebatis.core.annotation.Delete;
import io.manbang.ebatis.core.annotation.Index;
import io.manbang.ebatis.core.annotation.Update;
import io.manbang.ebatis.core.common.ActiveShardCountUtils;
import io.manbang.ebatis.core.meta.MetaUtils;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.ParameterMeta;
import io.manbang.ebatis.core.request.AbstractRequestFactory;
import io.manbang.ebatis.core.request.DeleteRequestFactory;
import io.manbang.ebatis.core.request.IndexRequestFactory;
import io.manbang.ebatis.core.request.RequestFactory;
import io.manbang.ebatis.core.request.UpdateRequestFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.Requests;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkRequestFactory
extends AbstractRequestFactory<Bulk, BulkRequest> {
    private static final Logger log = LoggerFactory.getLogger(BulkRequestFactory.class);
    public static final RequestFactory<BulkRequest> INSTANCE = new BulkRequestFactory();

    private BulkRequestFactory() {
    }

    @Override
    protected void setAnnotationMeta(BulkRequest request, Bulk bulk) {
        ((BulkRequest)request.setRefreshPolicy(bulk.refreshPolicy())).timeout(bulk.timeout()).waitForActiveShards(ActiveShardCountUtils.getActiveShardCount(bulk.waitForActiveShards()));
        BulkType type = bulk.bulkType();
        switch (type) {
            case INDEX: {
                MetaUtils.findFirstElement(bulk.index()).ifPresent(index -> request.requests().stream().map(IndexRequest.class::cast).forEach(req -> IndexRequestFactory.INSTANCE.setAnnotationMeta((IndexRequest)req, (Index)index)));
                break;
            }
            case DELETE: {
                MetaUtils.findFirstElement(bulk.delete()).ifPresent(delete -> request.requests().stream().map(DeleteRequest.class::cast).forEach(req -> DeleteRequestFactory.INSTANCE.setAnnotationMeta((DeleteRequest)req, (Delete)delete)));
                break;
            }
            case UPDATE: {
                MetaUtils.findFirstElement(bulk.update()).ifPresent(update -> request.requests().stream().map(UpdateRequest.class::cast).forEach(req -> UpdateRequestFactory.INSTANCE.setAnnotationMeta((UpdateRequest)req, (Update)update)));
                break;
            }
            default: {
                log.error("\u672a\u77e5\u7c7b\u578b");
            }
        }
    }

    @Override
    protected BulkRequest doCreate(MethodMeta meta, Object[] args) {
        Bulk bulk = meta.getAnnotation(Bulk.class);
        Collection<?> documents = this.getAllDocuments(meta, args);
        DocWriteRequest<?>[] requests = this.buildRequests(meta, bulk, documents);
        BulkRequest request = Requests.bulkRequest();
        request.add(requests);
        return request;
    }

    private DocWriteRequest<?>[] buildRequests(MethodMeta meta, Bulk bulk, Collection<?> documents) {
        RequestFactory requestFactory = bulk.bulkType().getRequestFactory();
        return (DocWriteRequest[])documents.stream().map(d -> requestFactory.create(meta, d)).map(DocWriteRequest.class::cast).toArray(DocWriteRequest[]::new);
    }

    private Collection<?> getAllDocuments(MethodMeta meta, Object[] args) {
        List<Object> docs;
        ParameterMeta parameterMeta = meta.getConditionParameter();
        Object arg = parameterMeta.getValue(args);
        if (parameterMeta.isCollection()) {
            docs = (List<Object>)arg;
        } else if (parameterMeta.isArray()) {
            docs = Arrays.asList((Object[])arg);
        } else {
            throw new UnsupportedOperationException("\u5165\u53c2\u5fc5\u987b\u662f\u6570\u636e\u6216\u8005\u96c6\u5408\u7c7b\u578b" + meta);
        }
        return docs;
    }
}

