/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.interceptor;

import io.manbang.ebatis.core.exception.InterceptorExcepiton;
import io.manbang.ebatis.core.interceptor.Interceptor;
import io.manbang.ebatis.core.interceptor.Interceptors;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.ServiceLoader;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;

public class InterceptorFactory {
    private static final LazyInitializer<Interceptor> INTERCEPTORS = new LazyInitializer<Interceptor>(){

        protected Interceptor initialize() {
            ServiceLoader<Interceptor> interceptorServiceLoader = ServiceLoader.load(Interceptor.class);
            ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>();
            for (Interceptor interceptor : interceptorServiceLoader) {
                interceptorList.add(interceptor);
            }
            interceptorList.sort(Comparator.comparingInt(Interceptor::getOrder));
            return new Interceptors(interceptorList);
        }
    };

    public static Interceptor interceptors() {
        try {
            return (Interceptor)INTERCEPTORS.get();
        }
        catch (ConcurrentException e) {
            throw new InterceptorExcepiton("\u83b7\u53d6 Interceptor \u5931\u8d25", e);
        }
    }
}

