/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.cluster;

import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.cluster.Credentials;
import io.manbang.ebatis.core.common.ObjectMapperHolder;
import io.manbang.ebatis.core.config.Env;
import io.manbang.ebatis.core.domain.ContextHolder;
import io.manbang.ebatis.core.domain.HttpConfig;
import io.manbang.ebatis.core.exception.ClusterCreationException;
import io.manbang.ebatis.core.request.CatRequest;
import io.manbang.ebatis.core.response.CatResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.lang3.concurrent.ConcurrentException;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultClientConnectionReuseStrategy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.RestHighLevelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCluster
implements Cluster {
    private static final Logger log = LoggerFactory.getLogger(AbstractCluster.class);
    private final AtomicBoolean highLevelClientInitialized = new AtomicBoolean(false);
    private final AtomicBoolean lowLevelClientInitialized = new AtomicBoolean(false);
    private final LazyInitializer<RestClient> lowLevelClientInitializer;
    private final LazyInitializer<RestHighLevelClient> highLevelClientInitializer;
    private final RestClientBuilder builder;
    private final HttpHost[] hosts;
    private String name;
    private final Credentials credentials;

    public AbstractCluster(String hostname, int port) {
        this(new HttpHost[]{new HttpHost(hostname, port)}, null);
    }

    public AbstractCluster(String hostname, int port, Credentials credentials) {
        this(new HttpHost[]{new HttpHost(hostname, port)}, credentials);
    }

    public AbstractCluster(HttpHost[] hosts) {
        this(hosts, null);
    }

    public AbstractCluster(HttpHost[] hosts, Credentials credentials) {
        this.credentials = credentials;
        this.hosts = hosts;
        this.builder = this.custom(this.createBuilder(hosts));
        this.name = Arrays.toString(hosts);
        this.lowLevelClientInitializer = this.createLowLevelClientInitializer();
        this.highLevelClientInitializer = this.createHighLevelClientInitializer();
    }

    private LazyInitializer<RestHighLevelClient> createHighLevelClientInitializer() {
        return new LazyInitializer<RestHighLevelClient>(){

            protected RestHighLevelClient initialize() {
                log.info("\u521b\u5efa\u9ad8\u7ea7ES\u96c6\u7fa4\u5ba2\u6237\u7aef\uff1a{}", (Object)AbstractCluster.this.name);
                AbstractCluster.this.highLevelClientInitialized.set(true);
                return new RestHighLevelClient(AbstractCluster.this.builder);
            }
        };
    }

    private LazyInitializer<RestClient> createLowLevelClientInitializer() {
        return new LazyInitializer<RestClient>(){

            protected RestClient initialize() {
                log.info("\u521b\u5efa\u4f4e\u7ea7ES\u96c6\u7fa4\u5ba2\u6237\u7aef\uff1a{}", (Object)AbstractCluster.this.name);
                AbstractCluster.this.lowLevelClientInitialized.set(true);
                return AbstractCluster.this.builder.build();
            }
        };
    }

    protected HttpHost[] getHosts() {
        return this.hosts;
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public RestClientBuilder getBuilder() {
        return this.builder;
    }

    protected RestClientBuilder createBuilder(HttpHost[] hosts) {
        return RestClient.builder((HttpHost[])hosts);
    }

    private HttpAsyncClientBuilder setHttpClientConfig(HttpAsyncClientBuilder builder) {
        builder.setConnectionReuseStrategy((ConnectionReuseStrategy)DefaultClientConnectionReuseStrategy.INSTANCE).setKeepAliveStrategy((ConnectionKeepAliveStrategy)DefaultConnectionKeepAliveStrategy.INSTANCE).setDefaultCredentialsProvider(this.credentials == null ? null : this.credentials.toCredentialsProvider());
        if (Env.isDebugEnabled()) {
            builder.addInterceptorLast(this::printRequest).addInterceptorLast(this::printResponse);
        }
        builder.addInterceptorLast(this::setRequestTimeout);
        this.customHttpClientConfig(builder);
        return builder;
    }

    protected void customHttpClientConfig(HttpAsyncClientBuilder builder) {
    }

    private RestClientBuilder custom(RestClientBuilder builder) {
        builder.setHttpClientConfigCallback(this::setHttpClientConfig);
        builder.setRequestConfigCallback(requestConfigBuilder -> requestConfigBuilder);
        return builder;
    }

    private void setRequestTimeout(HttpRequest request, HttpContext context) {
        HttpConfig httpConfig = ContextHolder.getContext().getHttpConfig();
        if (httpConfig == null) {
            return;
        }
        RequestConfig config = (RequestConfig)context.getAttribute("http.request-config");
        config = RequestConfig.copy((RequestConfig)config).setSocketTimeout(httpConfig.socketTimeout()).setConnectTimeout(httpConfig.connectTimeout()).setConnectionRequestTimeout(httpConfig.connectionRequestTimeout()).build();
        context.setAttribute("http.request-config", (Object)config);
    }

    private void printRequest(HttpRequest request, HttpContext context) throws IOException {
        HttpEntityEnclosingRequest enclosingRequest;
        HttpEntity entity;
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        sb.append(request.getRequestLine()).append(System.lineSeparator());
        for (Header header : request.getAllHeaders()) {
            sb.append(header).append(System.lineSeparator());
        }
        sb.append(System.lineSeparator());
        if (request instanceof HttpEntityEnclosingRequest && (entity = (enclosingRequest = (HttpEntityEnclosingRequest)request).getEntity()) != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(entity.getContent()));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    Map map = (Map)ObjectMapperHolder.objectMapper().readValue(line, Map.class);
                    String body = ObjectMapperHolder.objectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)map);
                    sb.append(body);
                }
            }
        }
        log.debug("{}", (Object)sb);
    }

    private void printResponse(HttpResponse response, HttpContext context) {
        StringBuilder sb = new StringBuilder(System.lineSeparator());
        sb.append(response.getStatusLine()).append(System.lineSeparator());
        for (Header header : response.getAllHeaders()) {
            sb.append(header).append(System.lineSeparator());
        }
        log.debug("{}", (Object)sb);
    }

    @Override
    public RestHighLevelClient highLevelClient() {
        try {
            return (RestHighLevelClient)this.highLevelClientInitializer.get();
        }
        catch (ConcurrentException e) {
            throw new ClusterCreationException("High Level Rest Client \u521b\u5efa\u5931\u8d25");
        }
    }

    @Override
    public RestClient lowLevelClient() {
        try {
            return (RestClient)this.lowLevelClientInitializer.get();
        }
        catch (ConcurrentException e) {
            throw new ClusterCreationException("Low Level Rest Client \u521b\u5efa\u5931\u8d25");
        }
    }

    @Override
    public void catAsync(CatRequest catRequest, final ActionListener<CatResponse> listener) {
        Request request = catRequest.toRequest();
        this.lowLevelClient().performRequestAsync(request, new ResponseListener(){

            public void onSuccess(Response response) {
                listener.onResponse((Object)new CatResponse());
            }

            public void onFailure(Exception exception) {
                listener.onFailure(exception);
            }
        });
    }

    @Override
    public void close() throws IOException {
        if (this.highLevelClientInitialized.get()) {
            log.info("\u5173\u95edHighLevelClient\uff1a{}", (Object)this.name);
            this.highLevelClient().close();
        }
        if (this.lowLevelClientInitialized.get()) {
            log.info("\u5173\u95edLowLevelClient\uff1a{}", (Object)this.name);
            this.lowLevelClient().close();
        }
    }

    public String toString() {
        return "AbstractCluster(name=" + this.getName() + ")";
    }
}

