/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.PageRequest;

public interface Pageable {
    public static Pageable of(int page, int size) {
        return Pageable.withOffset(page, size, 0);
    }

    public static Pageable first(int size) {
        return Pageable.of(0, size);
    }

    public static Pageable withOffset(int page, int size, int offset) {
        return new PageRequest(page, size, offset);
    }

    public static Pageable firstWithOffset(int size, int offset) {
        return Pageable.withOffset(0, size, offset);
    }

    public int getPage();

    public int getSize();

    public int getOffset();

    public Pageable next();

    public Pageable previous();

    default public int getFrom() {
        return this.getPage() * this.getSize() + this.getOffset();
    }
}

