/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.cluster;

import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.cluster.SimpleFederalCluster;
import io.manbang.ebatis.core.request.CatRequest;
import io.manbang.ebatis.core.response.CatResponse;
import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;

public interface FederalCluster
extends Cluster {
    public static FederalCluster of(Cluster ... clusters) {
        return new SimpleFederalCluster(clusters);
    }

    @Override
    default public RestHighLevelClient highLevelClient() {
        throw new UnsupportedOperationException("\u8054\u90a6\u96c6\u7fa4\uff0c\u4e0d\u652f\u6301\u8fd4\u56de highLevelClient");
    }

    @Override
    default public RestClient lowLevelClient() {
        throw new UnsupportedOperationException("\u8054\u90a6\u96c6\u7fa4\uff0c\u4e0d\u652f\u6301\u8fd4\u56de\u5e95\u5c42 lowLevelClient");
    }

    @Override
    default public void searchAsync(SearchRequest request, ActionListener<SearchResponse> listener) {
        throw new UnsupportedOperationException("\u8054\u90a6\u96c6\u7fa4\uff0c\u4e0d\u652f\u6301 searchAsync");
    }

    @Override
    default public void multiSearchAsync(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        throw new UnsupportedOperationException("\u8054\u90a6\u96c6\u7fa4\uff0c\u4e0d\u652f\u6301 multiSearchAsync");
    }

    @Override
    default public void updateAsync(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        for (Cluster cluster : this.getClusters()) {
            cluster.updateAsync(request, listener);
        }
    }

    @Override
    default public void deleteAsync(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        for (Cluster cluster : this.getClusters()) {
            cluster.deleteAsync(request, listener);
        }
    }

    @Override
    default public void bulkAsync(BulkRequest request, ActionListener<BulkResponse> listener) {
        for (Cluster cluster : this.getClusters()) {
            cluster.bulkAsync(request, listener);
        }
    }

    @Override
    default public void indexAsync(IndexRequest request, ActionListener<IndexResponse> listener) {
        for (Cluster cluster : this.getClusters()) {
            cluster.indexAsync(request, listener);
        }
    }

    @Override
    default public void deleteByQueryAsync(DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        for (Cluster cluster : this.getClusters()) {
            cluster.deleteByQueryAsync(request, listener);
        }
    }

    @Override
    default public void updateByQueryAsync(UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        for (Cluster cluster : this.getClusters()) {
            cluster.updateByQueryAsync(request, listener);
        }
    }

    @Override
    default public void catAsync(CatRequest request, ActionListener<CatResponse> listener) {
        throw new UnsupportedOperationException("\u8054\u90a6\u96c6\u7fa4\u4e0d\u652f\u6301cat");
    }

    @Override
    default public void getAsync(GetRequest request, ActionListener<GetResponse> listener) {
        throw new UnsupportedOperationException("\u8054\u90a6\u96c6\u7fa4\u4e0d\u652f\u6301GET");
    }

    @Override
    default public void scrollAsync(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        throw new UnsupportedOperationException("\u8054\u90a6\u96c6\u7fa4\u4e0d\u652f\u6301scroll");
    }

    @Override
    default public void mgetAsync(MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        throw new UnsupportedOperationException("\u8054\u90a6\u96c6\u7fa4\u4e0d\u652f\u6301multiGetAsync");
    }

    @Override
    default public void close() throws IOException {
        for (Cluster cluster : this.getClusters()) {
            cluster.close();
        }
    }

    public Cluster[] getClusters();
}

