/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.generic;

import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.exception.GenericTypeException;
import io.manbang.ebatis.core.generic.DefaultGenericType;
import io.manbang.ebatis.core.generic.DefaultMethodGenericType;
import io.manbang.ebatis.core.generic.MethodGenericType;
import io.manbang.ebatis.core.meta.MetaUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

public interface GenericType {
    public static GenericType forType(Type type) {
        return new DefaultGenericType(type);
    }

    public static GenericType forField(Field field) {
        return new DefaultGenericType(field.getGenericType());
    }

    public static GenericType forParameter(Parameter parameter) {
        return new DefaultGenericType(parameter.getParameterizedType());
    }

    public static MethodGenericType forMethod(Method method) {
        return new DefaultMethodGenericType(method);
    }

    default public boolean isPage() {
        return this.resolveOptional().map(c -> c == Page.class).orElse(false);
    }

    default public boolean isCompletableFuture() {
        return this.resolveOptional().map(c -> c == CompletableFuture.class).orElse(false);
    }

    default public boolean isCollection() {
        return this.resolveOptional().map(Collection.class::isAssignableFrom).orElse(false);
    }

    default public boolean isOptional() {
        return this.resolveOptional().map(c -> c == Optional.class).orElse(false);
    }

    default public boolean isArray() {
        return this.resolveOptional().map(Class::isArray).orElse(false);
    }

    default public boolean isWrapped() {
        return this.isPage() || this.isCompletableFuture() || this.isCollection() || this.isOptional();
    }

    default public boolean isBasic() {
        return this.resolveOptional().map(MetaUtils::isBasic).orElse(false);
    }

    public GenericType as(Class<?> var1);

    public Optional<Class<?>> resolveGenericOptional(int ... var1);

    default public Class<?> resolveGeneric(int ... indices) {
        return this.resolveGenericOptional(indices).orElseThrow(GenericTypeException::new);
    }

    public Optional<Class<?>> resolveOptional();

    default public Class<?> resolve() {
        return this.resolveOptional().orElseThrow(GenericTypeException::new);
    }

    public GenericType resolveType(int ... var1);

    default public GenericType asCompletableFuture() {
        return this.as(CompletableFuture.class);
    }

    default public GenericType asOptional() {
        return this.as(Optional.class);
    }

    default public GenericType asMap() {
        return this.as(Map.class);
    }

    default public GenericType asList() {
        return this.as(List.class);
    }

    default public GenericType asSet() {
        return this.as(Set.class);
    }

    default public boolean isAssignableTo(Class<?> clazz) {
        return clazz.isAssignableFrom(this.resolve());
    }

    default public boolean is(Class<?> clazz) {
        return clazz == this.resolve();
    }
}

