/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.builder;

import io.manbang.ebatis.core.annotation.Nested;
import io.manbang.ebatis.core.builder.AbstractQueryBuilderFactory;
import io.manbang.ebatis.core.builder.AutoQueryBuilderFactory;
import io.manbang.ebatis.core.exception.AttributeNotFoundException;
import io.manbang.ebatis.core.meta.ConditionMeta;
import io.manbang.ebatis.core.provider.PathProvider;
import java.util.Objects;
import java.util.Optional;
import org.apache.lucene.search.join.ScoreMode;
import org.elasticsearch.index.query.NestedQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

class NestedQueryBuilderFactory
extends AbstractQueryBuilderFactory<NestedQueryBuilder, Nested> {
    public static final NestedQueryBuilderFactory INSTANCE = new NestedQueryBuilderFactory();

    NestedQueryBuilderFactory() {
    }

    @Override
    protected NestedQueryBuilder doCreate(ConditionMeta conditionMeta, Object condition) {
        Nested nested;
        String path = null;
        ScoreMode scoreMod = null;
        if (condition instanceof PathProvider) {
            PathProvider provider = (PathProvider)condition;
            path = provider.getPath();
            scoreMod = provider.getScoreMode();
        }
        if (Objects.nonNull(nested = (Nested)Optional.ofNullable(conditionMeta).flatMap(c -> c.findAttributeAnnotation(Nested.class)).orElse(null))) {
            path = nested.path();
            scoreMod = nested.scoreMode();
        }
        if (Objects.isNull(path)) {
            throw new AttributeNotFoundException("\u6761\u4ef6\u5fc5\u987b\u5b9e\u73b0 PathProvider\u6216\u5728\u6ce8\u89e3\u4e0a\u8868\u660enest");
        }
        return QueryBuilders.nestedQuery((String)path, (QueryBuilder)AutoQueryBuilderFactory.INSTANCE.create(conditionMeta, condition), (ScoreMode)scoreMod);
    }
}

