/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.manbang.ebatis.core.response.Retries;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.reindex.BulkByScrollTask;

public class ByQueryResponse {
    private long took;
    @JsonProperty(value="timed_out")
    private boolean timeout;
    private long total;
    private long deleted;
    private long created;
    private long updated;
    private int batches;
    @JsonProperty(value="version_conflicts")
    private long versionConflicts;
    private long noops;
    private Retries retries;
    @JsonProperty(value="throttled_millis")
    private long throttledMillis;
    @JsonProperty(value="requests_per_second")
    private float requestsPerSecond;
    @JsonProperty(value="throttled_until_millis")
    private long throttledUntilMillis;

    public long getBulkRetries() {
        return this.retries.getBulk();
    }

    public long getSearchRetries() {
        return this.retries.getSearch();
    }

    public TimeValue getThrottled() {
        return TimeValue.timeValueMillis((long)this.throttledMillis);
    }

    public TimeValue getThrottledUntil() {
        return TimeValue.timeValueMillis((long)this.throttledUntilMillis);
    }

    public BulkByScrollTask.Status getStatus() {
        return new BulkByScrollTask.Status(null, this.total, this.updated, this.created, this.deleted, this.batches, this.versionConflicts, this.noops, this.getBulkRetries(), this.getSearchRetries(), this.getThrottled(), this.getRequestsPerSecond(), null, this.getThrottledUntil());
    }

    public long getTook() {
        return this.took;
    }

    public boolean isTimeout() {
        return this.timeout;
    }

    public long getTotal() {
        return this.total;
    }

    public long getDeleted() {
        return this.deleted;
    }

    public long getCreated() {
        return this.created;
    }

    public long getUpdated() {
        return this.updated;
    }

    public int getBatches() {
        return this.batches;
    }

    public long getVersionConflicts() {
        return this.versionConflicts;
    }

    public long getNoops() {
        return this.noops;
    }

    public Retries getRetries() {
        return this.retries;
    }

    public long getThrottledMillis() {
        return this.throttledMillis;
    }

    public float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public long getThrottledUntilMillis() {
        return this.throttledUntilMillis;
    }

    public void setTook(long took) {
        this.took = took;
    }

    @JsonProperty(value="timed_out")
    public void setTimeout(boolean timeout) {
        this.timeout = timeout;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setDeleted(long deleted) {
        this.deleted = deleted;
    }

    public void setCreated(long created) {
        this.created = created;
    }

    public void setUpdated(long updated) {
        this.updated = updated;
    }

    public void setBatches(int batches) {
        this.batches = batches;
    }

    @JsonProperty(value="version_conflicts")
    public void setVersionConflicts(long versionConflicts) {
        this.versionConflicts = versionConflicts;
    }

    public void setNoops(long noops) {
        this.noops = noops;
    }

    public void setRetries(Retries retries) {
        this.retries = retries;
    }

    @JsonProperty(value="throttled_millis")
    public void setThrottledMillis(long throttledMillis) {
        this.throttledMillis = throttledMillis;
    }

    @JsonProperty(value="requests_per_second")
    public void setRequestsPerSecond(float requestsPerSecond) {
        this.requestsPerSecond = requestsPerSecond;
    }

    @JsonProperty(value="throttled_until_millis")
    public void setThrottledUntilMillis(long throttledUntilMillis) {
        this.throttledUntilMillis = throttledUntilMillis;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ByQueryResponse)) {
            return false;
        }
        ByQueryResponse other = (ByQueryResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTook() != other.getTook()) {
            return false;
        }
        if (this.isTimeout() != other.isTimeout()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getDeleted() != other.getDeleted()) {
            return false;
        }
        if (this.getCreated() != other.getCreated()) {
            return false;
        }
        if (this.getUpdated() != other.getUpdated()) {
            return false;
        }
        if (this.getBatches() != other.getBatches()) {
            return false;
        }
        if (this.getVersionConflicts() != other.getVersionConflicts()) {
            return false;
        }
        if (this.getNoops() != other.getNoops()) {
            return false;
        }
        Retries this$retries = this.getRetries();
        Retries other$retries = other.getRetries();
        if (this$retries == null ? other$retries != null : !((Object)this$retries).equals(other$retries)) {
            return false;
        }
        if (this.getThrottledMillis() != other.getThrottledMillis()) {
            return false;
        }
        if (Float.compare(this.getRequestsPerSecond(), other.getRequestsPerSecond()) != 0) {
            return false;
        }
        return this.getThrottledUntilMillis() == other.getThrottledUntilMillis();
    }

    protected boolean canEqual(Object other) {
        return other instanceof ByQueryResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $took = this.getTook();
        result = result * 59 + (int)($took >>> 32 ^ $took);
        result = result * 59 + (this.isTimeout() ? 79 : 97);
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        long $deleted = this.getDeleted();
        result = result * 59 + (int)($deleted >>> 32 ^ $deleted);
        long $created = this.getCreated();
        result = result * 59 + (int)($created >>> 32 ^ $created);
        long $updated = this.getUpdated();
        result = result * 59 + (int)($updated >>> 32 ^ $updated);
        result = result * 59 + this.getBatches();
        long $versionConflicts = this.getVersionConflicts();
        result = result * 59 + (int)($versionConflicts >>> 32 ^ $versionConflicts);
        long $noops = this.getNoops();
        result = result * 59 + (int)($noops >>> 32 ^ $noops);
        Retries $retries = this.getRetries();
        result = result * 59 + ($retries == null ? 43 : ((Object)$retries).hashCode());
        long $throttledMillis = this.getThrottledMillis();
        result = result * 59 + (int)($throttledMillis >>> 32 ^ $throttledMillis);
        result = result * 59 + Float.floatToIntBits(this.getRequestsPerSecond());
        long $throttledUntilMillis = this.getThrottledUntilMillis();
        result = result * 59 + (int)($throttledUntilMillis >>> 32 ^ $throttledUntilMillis);
        return result;
    }

    public String toString() {
        return "ByQueryResponse(took=" + this.getTook() + ", timeout=" + this.isTimeout() + ", total=" + this.getTotal() + ", deleted=" + this.getDeleted() + ", created=" + this.getCreated() + ", updated=" + this.getUpdated() + ", batches=" + this.getBatches() + ", versionConflicts=" + this.getVersionConflicts() + ", noops=" + this.getNoops() + ", retries=" + this.getRetries() + ", throttledMillis=" + this.getThrottledMillis() + ", requestsPerSecond=" + this.getRequestsPerSecond() + ", throttledUntilMillis=" + this.getThrottledUntilMillis() + ")";
    }
}

