/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.annotation.Http;
import io.manbang.ebatis.core.annotation.Mapper;
import io.manbang.ebatis.core.common.AnnotationUtils;
import io.manbang.ebatis.core.domain.HttpConfig;
import io.manbang.ebatis.core.exception.AttributeNotFoundException;
import io.manbang.ebatis.core.exception.InstanceException;
import io.manbang.ebatis.core.exception.MapperAnnotationNotPresentException;
import io.manbang.ebatis.core.mapper.MappingRouter;
import io.manbang.ebatis.core.meta.AnnotatedMeta;
import io.manbang.ebatis.core.meta.MapperInterface;
import io.manbang.ebatis.core.meta.MapperMethod;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

class DefaultMapperInterface
implements MapperInterface {
    private final Class<?> mapperType;
    private final String[] indices;
    private final String[] types;
    private final String clusterRouter;
    private final MappingRouter mappingRouter;
    private final Map<Method, MapperMethod> mapperMethods;
    private final HttpConfig httpConfig;

    DefaultMapperInterface(Class<?> mapperType) {
        this.mapperType = mapperType;
        this.httpConfig = this.getHttpConfig(mapperType);
        Annotation mapperAnnotation = this.getMapperAnnotation(mapperType);
        this.indices = this.getIndices(mapperAnnotation);
        this.types = this.getTypes(mapperAnnotation);
        this.clusterRouter = this.getClusterRouter(mapperAnnotation);
        this.mappingRouter = this.getMappingRouter(mapperAnnotation);
        this.mapperMethods = this.getMapperMethods(mapperType);
    }

    private String getClusterRouter(Annotation mapperAnnotation) {
        return (String)this.getAnnotationAttribute(mapperAnnotation, "clusterRouter", false);
    }

    private String[] getTypes(Annotation mapperAnnotation) {
        return (String[])this.getAnnotationAttribute(mapperAnnotation, "types", false);
    }

    private String[] getIndices(Annotation mapperAnnotation) {
        return (String[])this.getAnnotationAttribute(mapperAnnotation, "indices", true);
    }

    private MappingRouter getMappingRouter(Annotation mapperAnnotation) {
        Class mappingRouterClazz = (Class)this.getAnnotationAttribute(mapperAnnotation, "mappingRouter", true);
        try {
            if (MappingRouter.class.equals((Object)mappingRouterClazz)) {
                return null;
            }
            return (MappingRouter)mappingRouterClazz.newInstance();
        }
        catch (Exception e) {
            throw new InstanceException(e);
        }
    }

    private <A> A getAnnotationAttribute(Annotation mapperAnnotation, String attributeName, boolean required) {
        Optional attribute = AnnotationUtils.findAttribute(mapperAnnotation, attributeName);
        if (attribute.isPresent()) {
            return attribute.get();
        }
        if (required) {
            throw new AttributeNotFoundException(mapperAnnotation.annotationType().getName() + '#' + attributeName);
        }
        return null;
    }

    private Annotation getMapperAnnotation(Class<?> mapperInterface) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = mapperInterface.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (annotationType != Mapper.class && !annotationType.isAnnotationPresent(Mapper.class)) continue;
            return annotation;
        }
        throw new MapperAnnotationNotPresentException(mapperInterface.getName());
    }

    private HttpConfig getHttpConfig(Class<?> mapperInterface) {
        Http http = mapperInterface.getAnnotation(Http.class);
        return http == null ? null : new HttpConfig().socketTimeout(http.socketTimeout()).connectTimeout(http.connectTimeout()).connectionRequestTimeout(http.connectionRequestTimeout());
    }

    private Map<Method, MapperMethod> getMapperMethods(Class<?> mapperInterface) {
        Map<Method, MapperMethod> methods = Arrays.stream(mapperInterface.getDeclaredMethods()).filter(this::filterMethod).map(m -> MapperMethod.of(this, m)).collect(Collectors.toMap(AnnotatedMeta::getElement, m -> m));
        return Collections.unmodifiableMap(methods);
    }

    private boolean filterMethod(Method method) {
        return !Modifier.isStatic(method.getModifiers());
    }

    @Override
    public String[] getIndices() {
        return this.indices;
    }

    @Override
    public String[] getTypes() {
        return this.types;
    }

    @Override
    public MappingRouter getMappingRouter() {
        return this.mappingRouter;
    }

    @Override
    public String getClusterRouterName() {
        return this.clusterRouter;
    }

    @Override
    public HttpConfig getHttpConfig() {
        return this.httpConfig;
    }

    @Override
    public MapperMethod getMapperMethod(Method method) {
        return this.mapperMethods.get(method);
    }

    @Override
    public Class<?> getElement() {
        return this.mapperType;
    }
}

