/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.manbang.ebatis.core.annotation.Field;
import io.manbang.ebatis.core.domain.Range;
import io.manbang.ebatis.core.domain.Script;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.ConditionMeta;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;

abstract class AbstractConditionMeta<E extends AnnotatedElement>
implements ConditionMeta {
    private final Class<?> type;
    private final boolean range;
    private final boolean script;
    private final boolean array;
    private final boolean collection;
    private final boolean arrayOrCollection;
    private final String name;
    private final Type genericType;

    protected AbstractConditionMeta(E element, Class<?> type, Type genericType) {
        this.type = type;
        this.genericType = genericType;
        this.array = type.isArray();
        this.collection = Collection.class.isAssignableFrom(type);
        boolean bl = this.arrayOrCollection = this.array || this.collection;
        if (this.arrayOrCollection) {
            Class<?> clazz = GenericType.forType(genericType).resolveGeneric(0);
            this.range = Range.class.isAssignableFrom(clazz);
            this.script = Script.class.isAssignableFrom(clazz);
        } else {
            this.range = Range.class.isAssignableFrom(type);
            this.script = Script.class.isAssignableFrom(type);
        }
        this.name = this.getName(element);
    }

    protected String getName(E element) {
        JsonProperty jsonProperty;
        String n;
        Field fieldAnnotation = element.getAnnotation(Field.class);
        if (fieldAnnotation != null) {
            n = fieldAnnotation.name();
            if (StringUtils.isNotBlank((CharSequence)n)) {
                return n;
            }
            n = fieldAnnotation.value();
            if (StringUtils.isNotBlank((CharSequence)n)) {
                return n;
            }
        }
        if ((jsonProperty = element.getAnnotation(JsonProperty.class)) != null && StringUtils.isNotBlank((CharSequence)(n = jsonProperty.value()))) {
            return n;
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isScript() {
        return this.script;
    }

    @Override
    public boolean isRange() {
        return this.range;
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    @Override
    public boolean isCollection() {
        return this.collection;
    }

    @Override
    public boolean isArrayOrCollection() {
        return this.arrayOrCollection;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }
}

