/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.common;

import io.manbang.ebatis.core.exception.MethodInvokeException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Stream;

public class MethodUtils {
    private static final String EQUALS_METHOD_NAME = "equals";
    private static final String HASH_CODE_METHOD_NAME = "hashCode";
    private static final String TO_STRING_METHOD_NAME = "toString";

    private MethodUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isObjectMethod(Method method) {
        if (method == null) {
            return false;
        }
        try {
            Object.class.getDeclaredMethod(method.getName(), method.getParameterTypes());
            return true;
        }
        catch (Exception ignore) {
            return false;
        }
    }

    public static boolean isOverriddenMethod(Method method, Class<?> baseClass) {
        Class<?> declaringClass = method.getDeclaringClass();
        if (declaringClass == baseClass || !baseClass.isAssignableFrom(declaringClass)) {
            return false;
        }
        return Stream.of(baseClass.getDeclaredMethods()).anyMatch(m -> MethodUtils.isSameSignature(method, m));
    }

    public static <E> E invoke(Method method, Object instance, Object ... args) {
        try {
            return (E)method.invoke(instance, args);
        }
        catch (Exception e) {
            throw new MethodInvokeException(e);
        }
    }

    public static boolean isSameSignature(Method m1, Method m2) {
        return m2.getReturnType().isAssignableFrom(m1.getReturnType()) && m1.getName().equals(m2.getName()) && Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    public static boolean isEqualsMethod(Method method) {
        if (method == null || !Objects.equals(method.getName(), EQUALS_METHOD_NAME)) {
            return false;
        }
        Class<?>[] paramTypes = method.getParameterTypes();
        return paramTypes.length == 1 && paramTypes[0] == Object.class;
    }

    public static boolean isHashCodeMethod(Method method) {
        return method != null && Objects.equals(method.getName(), HASH_CODE_METHOD_NAME) && method.getParameterTypes().length == 0;
    }

    public static boolean isToStringMethod(Method method) {
        return method != null && Objects.equals(method.getName(), TO_STRING_METHOD_NAME) && method.getParameterTypes().length == 0;
    }
}

