/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.cluster;

import io.manbang.ebatis.core.cluster.Credentials;
import io.manbang.ebatis.core.cluster.FixedWeightedCluster;
import io.manbang.ebatis.core.cluster.SimpleCluster;
import io.manbang.ebatis.core.cluster.WeightedCluster;
import io.manbang.ebatis.core.request.CatRequest;
import io.manbang.ebatis.core.response.CatResponse;
import java.io.Closeable;
import org.apache.http.HttpHost;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.ClearScrollRequest;
import org.elasticsearch.action.search.ClearScrollResponse;
import org.elasticsearch.action.search.MultiSearchRequest;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchScrollRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;

public interface Cluster
extends Closeable {
    public static Cluster localhost() {
        return Cluster.localhost(9200);
    }

    public static Cluster localhost(int port) {
        return Cluster.simple("127.0.0.1", port);
    }

    public static Cluster simple(String host, int port) {
        return Cluster.simple(host, port, null);
    }

    public static Cluster simple(String host, int port, String username, String password) {
        return Cluster.simple(host, port, Credentials.basic(username, password));
    }

    public static Cluster simple(String host, int port, Credentials credentials) {
        return new SimpleCluster(host, port, credentials);
    }

    public static Cluster simple(HttpHost[] hosts) {
        return Cluster.simple(hosts, null);
    }

    public static Cluster simple(HttpHost[] hosts, String username, String password) {
        return Cluster.simple(hosts, Credentials.basic(username, password));
    }

    public static Cluster simple(HttpHost[] hosts, Credentials credentials) {
        return new SimpleCluster(hosts, credentials);
    }

    public static WeightedCluster weighted(int weight, String host, int port) {
        return Cluster.weighted(weight, host, port, null);
    }

    public static WeightedCluster weighted(int weight, String host, int port, String username, String password) {
        return Cluster.weighted(weight, host, port, Credentials.basic(username, password));
    }

    public static WeightedCluster weighted(int weight, String host, int port, Credentials credentials) {
        return new FixedWeightedCluster(weight, host, port, credentials);
    }

    public static WeightedCluster weighted(int weight, HttpHost ... hosts) {
        return Cluster.weighted(weight, hosts, null);
    }

    public static WeightedCluster weighted(int weight, HttpHost[] hosts, String username, String password) {
        return Cluster.weighted(weight, hosts, Credentials.basic(username, password));
    }

    public static WeightedCluster weighted(int weight, HttpHost[] hosts, Credentials credentials) {
        return new FixedWeightedCluster(weight, hosts, credentials);
    }

    public String getName();

    public RestHighLevelClient highLevelClient();

    public RestClient lowLevelClient();

    default public void updateAsync(UpdateRequest request, ActionListener<UpdateResponse> listener) {
        this.highLevelClient().updateAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void deleteAsync(DeleteRequest request, ActionListener<DeleteResponse> listener) {
        this.highLevelClient().deleteAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void bulkAsync(BulkRequest request, ActionListener<BulkResponse> listener) {
        this.highLevelClient().bulkAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void searchAsync(SearchRequest request, ActionListener<SearchResponse> listener) {
        this.highLevelClient().searchAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void indexAsync(IndexRequest request, ActionListener<IndexResponse> listener) {
        this.highLevelClient().indexAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void deleteByQueryAsync(DeleteByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        this.highLevelClient().deleteByQueryAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void updateByQueryAsync(UpdateByQueryRequest request, ActionListener<BulkByScrollResponse> listener) {
        this.highLevelClient().updateByQueryAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void multiSearchAsync(MultiSearchRequest request, ActionListener<MultiSearchResponse> listener) {
        this.highLevelClient().msearchAsync(request, RequestOptions.DEFAULT, listener);
    }

    public void catAsync(CatRequest var1, ActionListener<CatResponse> var2);

    default public void getAsync(GetRequest request, ActionListener<GetResponse> listener) {
        this.highLevelClient().getAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void scrollAsync(SearchScrollRequest request, ActionListener<SearchResponse> listener) {
        this.highLevelClient().scrollAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void clearScrollAsync(ClearScrollRequest request, ActionListener<ClearScrollResponse> listener) {
        this.highLevelClient().clearScrollAsync(request, RequestOptions.DEFAULT, listener);
    }

    default public void mgetAsync(MultiGetRequest request, ActionListener<MultiGetResponse> listener) {
        this.highLevelClient().mgetAsync(request, RequestOptions.DEFAULT, listener);
    }
}

