/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.google.auto.service.AutoService;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.AbstractResponseExtractorProvider;
import io.manbang.ebatis.core.response.BooleanDeleteResponseExtractor;
import io.manbang.ebatis.core.response.RawResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import io.manbang.ebatis.core.response.RestStatusResponseExtractor;
import io.manbang.ebatis.core.response.VoidResponseExtractor;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.rest.RestStatus;

@AutoService(value={ResponseExtractorProvider.class})
public class DeleteResponseExtractorProvider
extends AbstractResponseExtractorProvider {
    public DeleteResponseExtractorProvider() {
        super(RequestType.DELETE);
    }

    @Override
    protected ResponseExtractor<?> getResponseExtractor(MethodMeta meta, GenericType genericType) {
        Class<?> resultClass = genericType.resolve();
        if (DeleteResponse.class == resultClass) {
            return RawResponseExtractor.INSTANCE;
        }
        if (RestStatus.class == resultClass) {
            return RestStatusResponseExtractor.INSTANCE;
        }
        if (Boolean.class == resultClass || Boolean.TYPE == resultClass) {
            return BooleanDeleteResponseExtractor.INSTANCE;
        }
        if (Void.class == resultClass || Void.TYPE == resultClass) {
            return VoidResponseExtractor.INSTANCE;
        }
        throw new UnsupportedOperationException();
    }
}

