/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.annotation.Agg;
import io.manbang.ebatis.core.annotation.Bulk;
import io.manbang.ebatis.core.annotation.Cat;
import io.manbang.ebatis.core.annotation.Delete;
import io.manbang.ebatis.core.annotation.DeleteByQuery;
import io.manbang.ebatis.core.annotation.Get;
import io.manbang.ebatis.core.annotation.Index;
import io.manbang.ebatis.core.annotation.MultiGet;
import io.manbang.ebatis.core.annotation.MultiSearch;
import io.manbang.ebatis.core.annotation.Search;
import io.manbang.ebatis.core.annotation.SearchScroll;
import io.manbang.ebatis.core.annotation.Update;
import io.manbang.ebatis.core.annotation.UpdateByQuery;
import io.manbang.ebatis.core.domain.ScrollResponse;
import io.manbang.ebatis.core.executor.RequestExecutor;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.provider.ScrollProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.search.MultiSearchResponse;
import org.elasticsearch.action.search.SearchResponse;

public enum RequestType {
    INDEX(Index.class, RequestExecutor.index()),
    BULK(Bulk.class, RequestExecutor.bulk()),
    DELETE(Delete.class, RequestExecutor.delete()),
    DELETE_BY_QUERY(DeleteByQuery.class, RequestExecutor.deleteByQuery()),
    UPDATE(Update.class, RequestExecutor.update()),
    UPDATE_BY_QUERY(UpdateByQuery.class, RequestExecutor.updateByQuery()),
    SEARCH(Search.class, RequestExecutor.search()){

        @Override
        public Optional<Class<?>> getEntityClass(MethodMeta meta) {
            GenericType genericType = RequestType.getReturnGenericType(meta);
            if (genericType.is(SearchResponse.class)) {
                return Optional.empty();
            }
            return genericType.resolveGenericOptional(0);
        }
    }
    ,
    SEARCH_SCROLL(SearchScroll.class, RequestExecutor.searchScroll()){

        @Override
        public boolean validate(MethodMeta meta) {
            SearchScroll scroll = meta.getAnnotation(SearchScroll.class);
            if (scroll.clearScroll()) {
                return true;
            }
            return meta.getConditionParameter().isAssignableTo(ScrollProvider.class);
        }

        @Override
        public Optional<Class<?>> getEntityClass(MethodMeta meta) {
            GenericType genericType = RequestType.getReturnGenericType(meta);
            if (genericType.is(SearchResponse.class)) {
                return Optional.empty();
            }
            if (genericType.is(ScrollResponse.class)) {
                return genericType.resolveGenericOptional(0);
            }
            return super.getEntityClass(meta);
        }
    }
    ,
    MULTI_SEARCH(MultiSearch.class, RequestExecutor.multiSearch()){

        @Override
        public Optional<Class<?>> getEntityClass(MethodMeta meta) {
            GenericType genericType = RequestType.getReturnGenericType(meta);
            if (genericType.is(MultiSearchResponse.class)) {
                return super.getEntityClass(meta);
            }
            return genericType.resolveGenericOptional(0, 0);
        }
    }
    ,
    AGG(Agg.class, RequestExecutor.agg()),
    GET(Get.class, RequestExecutor.get()){

        @Override
        public Optional<Class<?>> getEntityClass(MethodMeta meta) {
            GenericType genericType = RequestType.getReturnGenericType(meta);
            if (genericType.is(GetResponse.class)) {
                return super.getEntityClass(meta);
            }
            return Optional.ofNullable(genericType.resolve());
        }
    }
    ,
    MULTI_GET(MultiGet.class, RequestExecutor.multiGet()){

        @Override
        public Optional<Class<?>> getEntityClass(MethodMeta meta) {
            GenericType genericType = RequestType.getReturnGenericType(meta);
            if (genericType.is(MultiGetResponse.class)) {
                return super.getEntityClass(meta);
            }
            if (genericType.isArray() || genericType.isCollection()) {
                Class<?> clazz = genericType.resolveGeneric(0);
                if (MultiGetItemResponse.class == clazz) {
                    return super.getEntityClass(meta);
                }
                return genericType.resolveGenericOptional(0, 0);
            }
            return genericType.resolveGenericOptional(new int[0]);
        }
    }
    ,
    CAT(Cat.class, RequestExecutor.cat());

    private static final Map<Class<? extends Annotation>, RequestType> ANNOTATION_EXECUTOR_TYPES;
    private final Class<? extends Annotation> annotationClass;
    private final RequestExecutor requestExecutor;

    private RequestType(Class<? extends Annotation> annotationClass, RequestExecutor requestExecutor) {
        this.annotationClass = annotationClass;
        this.requestExecutor = requestExecutor;
    }

    private static GenericType getReturnGenericType(MethodMeta meta) {
        Class<?> returnType;
        Method method = (Method)meta.getElement();
        GenericType genericType = GenericType.forMethod(method).returnType();
        while (CompletableFuture.class == (returnType = genericType.resolve()) || Optional.class == returnType) {
            genericType = genericType.resolveType(0);
        }
        return genericType;
    }

    public static Optional<RequestType> valueOf(Method method) {
        Annotation[] annotations;
        for (Annotation annotation : annotations = method.getAnnotations()) {
            RequestType type = ANNOTATION_EXECUTOR_TYPES.get(annotation.annotationType());
            if (type == null) continue;
            return Optional.of(type);
        }
        return Optional.empty();
    }

    public static Optional<RequestType> valueOf(Class<?> annotationClass) {
        return Optional.ofNullable(ANNOTATION_EXECUTOR_TYPES.get(annotationClass));
    }

    public boolean validate(MethodMeta meta) {
        return meta != null;
    }

    public Optional<Class<?>> getEntityClass(MethodMeta meta) {
        return Optional.empty();
    }

    public Class<? extends Annotation> getAnnotationClass() {
        return this.annotationClass;
    }

    public RequestExecutor getRequestExecutor() {
        return this.requestExecutor;
    }

    static {
        ANNOTATION_EXECUTOR_TYPES = Stream.of(RequestType.values()).collect(Collectors.toMap(RequestType::getAnnotationClass, t -> t));
    }
}

