/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.Aggregation;
import io.manbang.ebatis.core.domain.SubAggregation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.sum.SumAggregationBuilder;

public class SumAggregation
implements SubAggregation<SumAggregation> {
    private final String name;
    private String fieldName;
    private final List<Aggregation> subAggregations = new ArrayList<Aggregation>();

    public SumAggregation(String name) {
        this.name = name;
    }

    @Override
    public SumAggregation subAgg(Aggregation ... aggs) {
        Collections.addAll(this.subAggregations, aggs);
        return this;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public SumAggregation fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    @Override
    public AggregationBuilder toAggBuilder() {
        SumAggregationBuilder sum = (SumAggregationBuilder)AggregationBuilders.sum((String)this.name).field(this.fieldName);
        this.subAggregations.forEach(sub -> {
            SumAggregationBuilder cfr_ignored_0 = (SumAggregationBuilder)sum.subAggregation(sub.toAggBuilder());
        });
        return sum;
    }
}

