/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.Aggregation;
import io.manbang.ebatis.core.domain.SubAggregation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.percentiles.PercentilesAggregationBuilder;

public class PercentilesAggregation
implements SubAggregation<PercentilesAggregation> {
    private final String name;
    private String fieldName;
    private static final double[] DEFAULT_PERCENTS = new double[]{1.0, 5.0, 25.0, 50.0, 75.0, 95.0, 99.0};
    private double[] percents = DEFAULT_PERCENTS;
    private double compression = 100.0;
    private boolean keyed = true;
    private final List<Aggregation> subAggregations = new ArrayList<Aggregation>();

    public PercentilesAggregation(String name) {
        this.name = name;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public PercentilesAggregation fieldName(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public PercentilesAggregation keyed(boolean keyed) {
        this.keyed = keyed;
        return this;
    }

    public PercentilesAggregation percentiles(double ... percents) {
        if (percents == null) {
            throw new IllegalArgumentException("[percents] must not be null: [" + this.name + "]");
        }
        if (percents.length == 0) {
            throw new IllegalArgumentException("[percents] must not be empty: [" + this.name + "]");
        }
        this.percents = percents;
        return this;
    }

    public PercentilesAggregation compression(double compression) {
        if (compression < 0.0) {
            throw new IllegalArgumentException("[compression] must be greater than or equal to 0. Found [" + compression + "] in [" + this.name + "]");
        }
        this.compression = compression;
        return this;
    }

    @Override
    public PercentilesAggregation subAgg(Aggregation ... aggs) {
        Collections.addAll(this.subAggregations, aggs);
        return this;
    }

    @Override
    public AggregationBuilder toAggBuilder() {
        PercentilesAggregationBuilder percentiles = (PercentilesAggregationBuilder)AggregationBuilders.percentiles((String)this.name).field(this.fieldName);
        percentiles.percentiles(this.percents);
        percentiles.compression(this.compression);
        percentiles.keyed(this.keyed);
        if (!this.subAggregations.isEmpty()) {
            this.subAggregations.forEach(subAgg -> {
                PercentilesAggregationBuilder cfr_ignored_0 = (PercentilesAggregationBuilder)percentiles.subAggregation(subAgg.toAggBuilder());
            });
        }
        return percentiles;
    }
}

