/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.builder.QueryBuilderFactory;
import io.manbang.ebatis.core.domain.NestedSort;
import java.util.Objects;
import org.elasticsearch.search.sort.NestedSortBuilder;

class DefaultNestedSort
implements NestedSort {
    private final String path;
    private Object condition;
    private int maxChildren = Integer.MAX_VALUE;
    private NestedSort nestedSort;

    DefaultNestedSort(String path) {
        this.path = path;
    }

    @Override
    public NestedSort filter(Object condition) {
        this.condition = condition;
        return this;
    }

    @Override
    public NestedSort maxChildren(int maxChildren) {
        this.maxChildren = maxChildren;
        return this;
    }

    @Override
    public NestedSort nested(NestedSort nestedSort) {
        this.nestedSort = nestedSort;
        return this;
    }

    @Override
    public NestedSortBuilder toNestedSortBuilder() {
        NestedSortBuilder nestedSortBuilder = new NestedSortBuilder(this.path);
        nestedSortBuilder.setMaxChildren(this.maxChildren);
        if (Objects.nonNull(this.condition)) {
            nestedSortBuilder.setFilter(QueryBuilderFactory.bool().create(null, this.condition));
        }
        if (Objects.nonNull(this.nestedSort)) {
            nestedSortBuilder.setNestedSort(this.nestedSort.toNestedSortBuilder());
        }
        return nestedSortBuilder;
    }
}

