/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.cluster;

import io.manbang.ebatis.core.cluster.Cluster;
import io.manbang.ebatis.core.cluster.RandomClusterRouter;
import io.manbang.ebatis.core.cluster.RoundRobbinClusterRouter;
import io.manbang.ebatis.core.cluster.SimpleWeightedClusterRouter;
import io.manbang.ebatis.core.cluster.SingleClusterRouter;
import io.manbang.ebatis.core.cluster.WeightedCluster;
import io.manbang.ebatis.core.cluster.WeightedClusterRouter;
import io.manbang.ebatis.core.meta.MethodMeta;
import java.io.Closeable;

public interface ClusterRouter
extends Closeable {
    public static ClusterRouter localhost() {
        return ClusterRouter.single(Cluster.localhost());
    }

    public static ClusterRouter single(Cluster cluster) {
        return new SingleClusterRouter(cluster);
    }

    public static ClusterRouter roundRobbin(Cluster ... clusters) {
        return new RoundRobbinClusterRouter(clusters);
    }

    public static ClusterRouter random(Cluster ... clusters) {
        return new RandomClusterRouter(clusters);
    }

    public static WeightedClusterRouter weighted(WeightedCluster ... clusters) {
        return new SimpleWeightedClusterRouter(clusters);
    }

    public static ClusterRouter localhost(int port) {
        return ClusterRouter.single(Cluster.localhost(port));
    }

    public Cluster route(MethodMeta var1);
}

