/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.AbstractResponseExtractorProvider;
import io.manbang.ebatis.core.response.MultiGetResponseExtractor;
import io.manbang.ebatis.core.response.RawResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import java.lang.reflect.Array;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;

@AutoService(value={ResponseExtractorProvider.class})
public class MultiGetResponseExtractorProvider
extends AbstractResponseExtractorProvider {
    public MultiGetResponseExtractorProvider() {
        super(RequestType.MULTI_GET);
    }

    @Override
    protected ResponseExtractor<?> getResponseExtractor(MethodMeta meta, GenericType genericType) {
        Class<?> resultClass = genericType.resolve();
        if (MultiGetResponse.class == resultClass) {
            return RawResponseExtractor.INSTANCE;
        }
        if (resultClass.isArray()) {
            Class<?> entityClass = genericType.resolveGeneric(0);
            if (MultiGetItemResponse.class == entityClass) {
                return response -> ((MultiGetResponse)response).getResponses();
            }
            if (Optional.class == entityClass) {
                Class<?> entityClazz = genericType.resolveGeneric(0, 0);
                return response -> (Optional[])Stream.of(MultiGetResponseExtractor.of(entityClazz).doExtractData((MultiGetResponse)response)).map(Optional::ofNullable).toArray(i -> (Optional[])Array.newInstance(Optional.class, i));
            }
            return MultiGetResponseExtractor.of(entityClass);
        }
        if (List.class.isAssignableFrom(resultClass)) {
            Class<?> entityClass = genericType.resolveGeneric(0);
            if (MultiGetItemResponse.class == entityClass) {
                return response -> Lists.newArrayList((Object[])((MultiGetResponse)response).getResponses());
            }
            if (Optional.class == entityClass) {
                Class<?> entityClazz = genericType.resolveGeneric(0, 0);
                return response -> Stream.of(MultiGetResponseExtractor.of(entityClazz).doExtractData((MultiGetResponse)response)).map(Optional::ofNullable).collect(Collectors.toList());
            }
            return response -> Lists.newArrayList((Object[])MultiGetResponseExtractor.of(entityClass).doExtractData((MultiGetResponse)response));
        }
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u7c7b\u578b");
    }
}

