/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.google.auto.service.AutoService;
import com.google.common.collect.Lists;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.AbstractResponseExtractorProvider;
import io.manbang.ebatis.core.response.BooleanBulkResponseExtractor;
import io.manbang.ebatis.core.response.RawResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import java.util.List;
import org.elasticsearch.action.bulk.BulkResponse;

@AutoService(value={ResponseExtractorProvider.class})
public class BulkResponseExtractorProvider
extends AbstractResponseExtractorProvider {
    public BulkResponseExtractorProvider() {
        super(RequestType.BULK);
    }

    @Override
    protected ResponseExtractor<?> getResponseExtractor(MethodMeta meta, GenericType genericType) {
        Class<?> resultClass = genericType.resolve();
        if (Boolean.class == resultClass || Boolean.TYPE == resultClass) {
            return BooleanBulkResponseExtractor.INSTANCE;
        }
        if (BulkResponse.class == resultClass) {
            return RawResponseExtractor.INSTANCE;
        }
        if (List.class.isAssignableFrom(resultClass)) {
            return response -> Lists.newArrayList((Object[])((BulkResponse)response).getItems());
        }
        if (resultClass.isArray()) {
            return response -> ((BulkResponse)response).getItems();
        }
        throw new UnsupportedOperationException();
    }
}

