/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.annotation.Prefix;
import io.manbang.ebatis.core.annotation.QueryType;
import io.manbang.ebatis.core.builder.QueryBuilderFactory;
import io.manbang.ebatis.core.common.AnnotationUtils;
import io.manbang.ebatis.core.exception.ConditionNotSupportException;
import io.manbang.ebatis.core.exception.EbatisException;
import io.manbang.ebatis.core.exception.ReadMethodInvokeException;
import io.manbang.ebatis.core.exception.ReadMethodNotFoundException;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.AbstractConditionMeta;
import io.manbang.ebatis.core.meta.ClassMeta;
import io.manbang.ebatis.core.meta.FieldMeta;
import io.manbang.ebatis.core.meta.MetaUtils;
import io.manbang.ebatis.core.meta.QueryClauses;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

class DefaultFieldMeta
extends AbstractConditionMeta<Field>
implements FieldMeta {
    private final Field field;
    private final boolean basic;
    private final boolean basicArrayOrCollection;
    private final Method readMethod;
    private final Class<? extends Annotation> queryClauseAnnotationClass;
    private final Annotation queryClauseAnnotation;
    private final QueryBuilderFactory queryBuilderFactory;
    private final boolean termsQuery;
    private final Map<Class<? extends Annotation>, Optional<? extends Annotation>> metas = new ConcurrentHashMap<Class<? extends Annotation>, Optional<? extends Annotation>>();

    DefaultFieldMeta(Field field) {
        super(field, field.getType(), field.getGenericType());
        this.field = field;
        this.readMethod = this.getReadMethod(field);
        Class<?> type = this.getActualType(field);
        this.basic = MetaUtils.isBasic(type);
        this.basicArrayOrCollection = this.isArrayOrCollection() && this.basic;
        this.queryClauseAnnotationClass = QueryClauses.getQueryClauseClass(this);
        Optional<? extends Annotation> annotation = this.findAnnotation(this.queryClauseAnnotationClass);
        this.queryClauseAnnotation = annotation.orElse(null);
        this.queryBuilderFactory = annotation.flatMap(a -> AnnotationUtils.findAttribute(a, QueryType.class)).orElse(QueryType.AUTO).getQueryBuilderFactory();
        this.termsQuery = this.queryBuilderFactory == QueryBuilderFactory.terms();
        this.validate();
    }

    private void validate() {
        boolean isBoolean;
        boolean isExists = this.queryBuilderFactory == QueryBuilderFactory.exists();
        boolean bl = isBoolean = Boolean.TYPE == this.field.getType() || Boolean.class == this.field.getType();
        if (isExists && !isBoolean) {
            throw new ConditionNotSupportException(this.field + ":Exists query must be boolean or Boolean!");
        }
    }

    private Class<?> getActualType(Field field) {
        Class<?> type = this.isArray() ? this.getType().getComponentType() : (this.isCollection() ? GenericType.forField(field).resolveGeneric(0) : this.getType());
        return type;
    }

    @Override
    public Field getElement() {
        return this.field;
    }

    private Method getReadMethod(Field field) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(field.getDeclaringClass());
        }
        catch (IntrospectionException e) {
            throw new EbatisException("Introspect exception!", e);
        }
        for (PropertyDescriptor propertyDescriptor : beanInfo.getPropertyDescriptors()) {
            if (!propertyDescriptor.getName().equals(field.getName())) continue;
            return propertyDescriptor.getReadMethod();
        }
        throw new ReadMethodNotFoundException(field.toString());
    }

    @Override
    protected String getName(Field field) {
        String name = super.getName(field);
        name = StringUtils.isBlank((CharSequence)name) ? field.getName() : name;
        Class<?> declaringClass = field.getDeclaringClass();
        String prefix = this.getPrefix(declaringClass);
        if (prefix == null) {
            return name;
        }
        return String.format("%s.%s", prefix, name);
    }

    private String getPrefix(Class<?> clazz) {
        if (clazz.isAnnotationPresent(Prefix.class)) {
            return StringUtils.trimToNull((String)clazz.getAnnotation(Prefix.class).value());
        }
        return null;
    }

    @Override
    public <A extends Annotation> Optional<A> findAttributeAnnotation(Class<A> annotationClass) {
        return this.metas.computeIfAbsent(annotationClass, clazz -> this.getQueryClauseAnnotation().flatMap(a -> AnnotationUtils.findAttributeAnnotation(a, clazz)));
    }

    @Override
    public Object getValue(Object instance) {
        try {
            return this.readMethod.invoke(instance, new Object[0]);
        }
        catch (Exception e) {
            throw new ReadMethodInvokeException(e);
        }
    }

    @Override
    public boolean isBasic() {
        return this.basic;
    }

    @Override
    public boolean isBasicArrayOrCollection() {
        return this.basicArrayOrCollection;
    }

    @Override
    public Class<? extends Annotation> getQueryClauseAnnotationClass() {
        return this.queryClauseAnnotationClass;
    }

    @Override
    public QueryBuilderFactory getQueryBuilderFactory() {
        return this.queryBuilderFactory;
    }

    @Override
    public Optional<Annotation> getQueryClauseAnnotation() {
        return Optional.ofNullable(this.queryClauseAnnotation);
    }

    @Override
    public Map<Class<? extends Annotation>, List<FieldMeta>> getQueryClauses(Object instance) {
        return ClassMeta.field(this.field, instance == null ? null : instance.getClass()).getQueryClauses();
    }

    @Override
    public boolean isTermsQuery() {
        return this.termsQuery;
    }
}

