/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.domain.Context;
import io.manbang.ebatis.core.domain.HttpConfig;
import io.manbang.ebatis.core.domain.Pageable;
import io.manbang.ebatis.core.response.ResponseExtractor;
import java.util.Optional;

public class ContextHolder {
    private static final ThreadLocal<Context> CONTEXT_THREAD_LOCAL = ThreadLocal.withInitial(Context::new);

    private ContextHolder() {
        throw new UnsupportedOperationException();
    }

    public static Context getContext() {
        return CONTEXT_THREAD_LOCAL.get();
    }

    public static void setContext(Context context) {
        CONTEXT_THREAD_LOCAL.set(context);
    }

    public static Optional<ResponseExtractor<?>> getResponseExtractor() {
        return ContextHolder.getContext().getResponseExtractor();
    }

    public static void setResponseExtractor(ResponseExtractor<?> responseExtractor) {
        ContextHolder.getContext().setResponseExtractor(responseExtractor);
    }

    static Optional<Pageable[]> getPageables() {
        return ContextHolder.getContext().getPageables();
    }

    public static void setPageables(Pageable[] pageables) {
        ContextHolder.getContext().setPageables(pageables);
    }

    static Optional<Pageable> getPageable() {
        return ContextHolder.getContext().getPageable();
    }

    public static void setPageable(Pageable pageable) {
        ContextHolder.getContext().setPageable(pageable);
    }

    public static void remove() {
        CONTEXT_THREAD_LOCAL.remove();
    }

    public static void setValue(String key, Object o) {
        ContextHolder.getContext().setValue(key, o);
    }

    public static String getString(String key) {
        return (String)ContextHolder.getValue(key);
    }

    public static Boolean getBoolean(String key) {
        return (Boolean)ContextHolder.getValue(key);
    }

    public static Integer getInteger(String key) {
        return (Integer)ContextHolder.getValue(key);
    }

    public static <T> T getValue(String key) {
        return (T)ContextHolder.getContext().getValue(key);
    }

    public static void setHttpConfig(HttpConfig httpConfig) {
        ContextHolder.getContext().setHttpConfig(httpConfig);
    }
}

