/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.meta.AnnotationAttribute;
import io.manbang.ebatis.core.meta.AnnotationMeta;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class CachedAnnotationMeta
implements AnnotationMeta {
    private static final Map<Class<? extends Annotation>, AnnotationMeta> METAS = new HashMap<Class<? extends Annotation>, AnnotationMeta>();
    private final Class<? extends Annotation> annotationType;
    private final List<AnnotationAttribute> attributes;

    private CachedAnnotationMeta(Class<? extends Annotation> annotationType) {
        this.annotationType = annotationType;
        this.attributes = this.getAttributes(annotationType);
    }

    static AnnotationMeta of(Class<? extends Annotation> annotationClass) {
        return METAS.computeIfAbsent(annotationClass, CachedAnnotationMeta::new);
    }

    private List<AnnotationAttribute> getAttributes(Class<? extends Annotation> annotationClass) {
        return Collections.unmodifiableList(Stream.of(annotationClass.getDeclaredMethods()).map(AnnotationAttribute::of).collect(Collectors.toList()));
    }

    @Override
    public List<AnnotationAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public Class<? extends Annotation> getAnnotationType() {
        return this.annotationType;
    }

    @Override
    public Class<? extends Annotation> getElement() {
        return this.getAnnotationType();
    }
}

