/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.builder;

import io.manbang.ebatis.core.annotation.MultiMatch;
import io.manbang.ebatis.core.builder.AbstractQueryBuilderFactory;
import io.manbang.ebatis.core.exception.EbatisException;
import io.manbang.ebatis.core.meta.ConditionMeta;
import io.manbang.ebatis.core.provider.MultiMatchFieldProvider;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

class MultiMatchQueryBuilderFactory
extends AbstractQueryBuilderFactory<MultiMatchQueryBuilder, MultiMatch> {
    static final MultiMatchQueryBuilderFactory INSTANCE = new MultiMatchQueryBuilderFactory();

    private MultiMatchQueryBuilderFactory() {
    }

    @Override
    protected void setAnnotationMeta(MultiMatchQueryBuilder builder, MultiMatch multiMatch) {
        Float cutoffFrequency = multiMatch.cutoffFrequency() < 0.0f || multiMatch.cutoffFrequency() > 1.0f ? null : Float.valueOf(multiMatch.cutoffFrequency());
        builder.autoGenerateSynonymsPhraseQuery(multiMatch.autoGenerateSynonymsPhraseQuery()).cutoffFrequency(cutoffFrequency).fuzziness((Object)StringUtils.trimToNull((String)multiMatch.fuzziness())).fuzzyRewrite(StringUtils.trimToNull((String)multiMatch.fuzzyRewrite())).fuzzyTranspositions(multiMatch.fuzzyTranspositions()).lenient(multiMatch.lenient()).maxExpansions(multiMatch.maxExpansions()).prefixLength(multiMatch.prefixLength()).minimumShouldMatch(StringUtils.trimToNull((String)multiMatch.minimumShouldMatch())).operator(multiMatch.operator()).slop(multiMatch.slop()).tieBreaker(multiMatch.tieBreaker());
    }

    @Override
    protected MultiMatchQueryBuilder doCreate(ConditionMeta meta, Object condition) {
        MultiMatch multiMatch = meta.findAttributeAnnotation(MultiMatch.class).orElseThrow(EbatisException::new);
        Object[] fields = multiMatch.fields();
        if (condition instanceof MultiMatchFieldProvider) {
            fields = (String[])ArrayUtils.addAll((Object[])fields, (Object[])((MultiMatchFieldProvider)condition).getFields());
        }
        return QueryBuilders.multiMatchQuery((Object)String.valueOf(condition), (String[])fields);
    }
}

