/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.domain.ContextHolder;
import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.domain.PageImpl;
import io.manbang.ebatis.core.domain.Pageable;
import io.manbang.ebatis.core.response.DocumentPageExtractor;
import io.manbang.ebatis.core.response.MultiSearchResponseExtractor;
import org.elasticsearch.action.search.MultiSearchResponse;

public class PageArrayMultiSearchResponseExtractor<T>
implements MultiSearchResponseExtractor<Page<T>[]> {
    private final DocumentPageExtractor<T> extractor;

    public PageArrayMultiSearchResponseExtractor(DocumentPageExtractor<T> extractor) {
        this.extractor = extractor;
    }

    @Override
    public Page<T>[] doExtractData(MultiSearchResponse response) {
        MultiSearchResponse.Item[] responses = response.getResponses();
        Pageable[] pageables = ContextHolder.getContext().getPageables().orElse(new Pageable[response.getResponses().length]);
        PageImpl[] pages = new PageImpl[pageables.length];
        for (int i = 0; i < responses.length; ++i) {
            MultiSearchResponse.Item item = responses[i];
            ContextHolder.setPageable(pageables[i]);
            pages[i] = this.extractor.doExtractData(item.getResponse());
        }
        return pages;
    }
}

