/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import io.manbang.ebatis.core.domain.ContextHolder;
import io.manbang.ebatis.core.domain.Page;
import io.manbang.ebatis.core.domain.Pageable;
import io.manbang.ebatis.core.exception.PageableNotFoundException;
import io.manbang.ebatis.core.response.DocumentExtractor;
import io.manbang.ebatis.core.response.DocumentMapper;
import io.manbang.ebatis.core.response.SearchResponseExtractor;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.search.SearchResponse;

public class DocumentPageExtractor<T>
implements SearchResponseExtractor<Page<T>> {
    private static final Page<?> EMPTY_PAGE = Page.of(0L, Collections.emptyList(), Pageable.of(0, 20));
    private final DocumentExtractor<T> documentExtractor;

    public DocumentPageExtractor(DocumentMapper<T> documentMapper) {
        this.documentExtractor = new DocumentExtractor<T>(documentMapper, Integer.MAX_VALUE);
    }

    @Override
    public Page<T> doExtractData(SearchResponse response) {
        List documents = (List)this.documentExtractor.extractData((ActionResponse)response);
        long total = response.getHits().getTotalHits();
        Pageable pageable = ContextHolder.getContext().getPageable().orElseThrow(PageableNotFoundException::new);
        return Page.of(total, documents, pageable);
    }

    @Override
    public Page<T> empty() {
        return EMPTY_PAGE;
    }
}

