/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain;

import io.manbang.ebatis.core.annotation.Ignore;
import io.manbang.ebatis.core.domain.Pageable;

public class PageRequest
implements Pageable {
    @Ignore
    private int page;
    @Ignore
    private int size;
    @Ignore
    private int offset;

    public PageRequest() {
        this(0, 20, 0);
    }

    public PageRequest(int page, int size) {
        this(page, size, 0);
    }

    public PageRequest(int page, int size, int offset) {
        this.page = page;
        this.size = size;
        this.offset = offset;
    }

    @Override
    public int getPage() {
        return this.page;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public Pageable next() {
        return Pageable.withOffset(this.page + 1, this.size, this.offset);
    }

    @Override
    public Pageable previous() {
        return this.page == 0 ? Pageable.firstWithOffset(this.size, this.offset) : Pageable.withOffset(this.page - 1, this.size, this.offset);
    }

    public void setPage(int page) {
        this.page = page;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public String toString() {
        return "PageRequest(page=" + this.getPage() + ", size=" + this.getSize() + ", offset=" + this.getOffset() + ")";
    }
}

