/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.builder;

import io.manbang.ebatis.core.annotation.Filter;
import io.manbang.ebatis.core.annotation.Must;
import io.manbang.ebatis.core.annotation.MustNot;
import io.manbang.ebatis.core.annotation.Should;
import io.manbang.ebatis.core.builder.QueryBuilderFactory;
import io.manbang.ebatis.core.meta.FieldMeta;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public enum QueryClauseType {
    MUST(Must.class){

        @Override
        public void addQueryBuilder(BoolQueryBuilder builder, List<FieldMeta> fields, Object instance) {
            QueryClauseType.combineQueryBuilder(arg_0 -> ((BoolQueryBuilder)builder).must(arg_0), fields, instance);
        }
    }
    ,
    MUST_NOT(MustNot.class){

        @Override
        public void addQueryBuilder(BoolQueryBuilder builder, List<FieldMeta> fields, Object instance) {
            QueryClauseType.combineQueryBuilder(arg_0 -> ((BoolQueryBuilder)builder).mustNot(arg_0), fields, instance);
        }
    }
    ,
    SHOULD(Should.class){

        @Override
        public void addQueryBuilder(BoolQueryBuilder builder, List<FieldMeta> fields, Object instance) {
            for (FieldMeta field : fields) {
                Should should = field.getAnnotation(Should.class);
                String minimumShouldMatch = StringUtils.trimToNull((String)should.minimumShouldMatch());
                if (minimumShouldMatch == null) continue;
                builder.minimumShouldMatch(should.minimumShouldMatch());
                break;
            }
            QueryClauseType.combineQueryBuilder(arg_0 -> ((BoolQueryBuilder)builder).should(arg_0), fields, instance);
        }
    }
    ,
    FILTER(Filter.class){

        @Override
        public void addQueryBuilder(BoolQueryBuilder builder, List<FieldMeta> fields, Object instance) {
            QueryClauseType.combineQueryBuilder(arg_0 -> ((BoolQueryBuilder)builder).filter(arg_0), fields, instance);
        }
    };

    private static final Map<Class<? extends Annotation>, QueryClauseType> QUERY_CLAUSE_TYPES;
    private final Class<? extends Annotation> queryClauseClass;

    private QueryClauseType(Class<? extends Annotation> queryClauseClass) {
        this.queryClauseClass = queryClauseClass;
    }

    public static QueryClauseType valueOf(Class<? extends Annotation> queryClauseTypeClass) {
        return QUERY_CLAUSE_TYPES.get(queryClauseTypeClass);
    }

    private static void combineQueryBuilder(QueryClauseCombiner combiner, List<FieldMeta> fields, Object instance) {
        LinkedList<QueryBuilder> builders = new LinkedList<QueryBuilder>();
        for (FieldMeta meta : fields) {
            QueryBuilder builder;
            Object value = meta.getValue(instance);
            QueryBuilderFactory queryBuilderFactory = meta.getQueryBuilderFactory();
            if (meta.isTermsQuery()) {
                builder = queryBuilderFactory.create(meta, value);
                if (builder == null) continue;
                builders.add(builder);
                continue;
            }
            if (meta.isArray()) {
                Optional.ofNullable(value).map(Object[].class::cast).map(Arrays::stream).orElseGet(Stream::empty).map(v -> queryBuilderFactory.create(meta, v)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> builders));
                continue;
            }
            if (meta.isCollection()) {
                Optional.ofNullable(value).map(Collection.class::cast).map(Collection::stream).orElseGet(Stream::empty).map(v -> queryBuilderFactory.create(meta, v)).filter(Objects::nonNull).collect(Collectors.toCollection(() -> builders));
                continue;
            }
            builder = queryBuilderFactory.create(meta, value);
            if (builder == null) continue;
            builders.add(builder);
        }
        builders.forEach(combiner::combine);
    }

    public Class<? extends Annotation> getQueryClauseClass() {
        return this.queryClauseClass;
    }

    public abstract void addQueryBuilder(BoolQueryBuilder var1, List<FieldMeta> var2, Object var3);

    static {
        QUERY_CLAUSE_TYPES = Stream.of(QueryClauseType.values()).collect(Collectors.toMap(QueryClauseType::getQueryClauseClass, t -> t));
    }

    @FunctionalInterface
    private static interface QueryClauseCombiner {
        public void combine(QueryBuilder var1);
    }
}

