/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.response;

import com.google.auto.service.AutoService;
import io.manbang.ebatis.core.generic.GenericType;
import io.manbang.ebatis.core.meta.MethodMeta;
import io.manbang.ebatis.core.meta.RequestType;
import io.manbang.ebatis.core.response.AbstractResponseExtractorProvider;
import io.manbang.ebatis.core.response.AggregationListResponseExtractor;
import io.manbang.ebatis.core.response.AggregationMapResponseExtractor;
import io.manbang.ebatis.core.response.AggregationsResponseExtractor;
import io.manbang.ebatis.core.response.RawResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractor;
import io.manbang.ebatis.core.response.ResponseExtractorProvider;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.Aggregations;

@AutoService(value={ResponseExtractorProvider.class})
public class AggResponseExtractorProvider
extends AbstractResponseExtractorProvider {
    public AggResponseExtractorProvider() {
        super(RequestType.AGG);
    }

    @Override
    protected ResponseExtractor<?> getResponseExtractor(MethodMeta meta, GenericType genericType) {
        Class<?> resultClass = genericType.resolve();
        if (SearchResponse.class == resultClass) {
            return RawResponseExtractor.INSTANCE;
        }
        if (Aggregations.class == resultClass) {
            return AggregationsResponseExtractor.INSTANCE;
        }
        if (List.class.isAssignableFrom(resultClass)) {
            if (Aggregation.class == genericType.resolveGeneric(0)) {
                return AggregationListResponseExtractor.INSTANCE;
            }
            throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u7c7b\u578b");
        }
        if (Map.class.isAssignableFrom(resultClass)) {
            Class<?> keyClass = genericType.resolveGeneric(0);
            Class<?> valueClass = genericType.resolveGeneric(1);
            if (String.class == keyClass && Aggregation.class == valueClass) {
                return AggregationMapResponseExtractor.INSTANCE;
            }
            throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u7c7b\u578b");
        }
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301\u7684\u8fd4\u56de\u503c\u7c7b\u578b");
    }
}

