/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.domain.Page;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ResultType {
    COMPLETABLE_FUTURE((Class)CompletableFuture.class){

        @Override
        public <T> Object adaptResult(CompletableFuture<T> futureResult) {
            return futureResult;
        }
    }
    ,
    OPTIONAL((Class)Optional.class){

        @Override
        public <T> Optional<Object> adaptResult(CompletableFuture<T> futureResult) {
            return Optional.ofNullable(futureResult.join());
        }
    }
    ,
    PAGE((Class)Page.class){

        @Override
        public <T> Object adaptResult(CompletableFuture<T> futureResult) {
            return futureResult.join();
        }
    }
    ,
    LIST((Class)List.class){

        @Override
        public <T> Object adaptResult(CompletableFuture<T> futureResult) {
            return futureResult.join();
        }
    }
    ,
    OTHER((Class)Object.class){

        @Override
        public <T> Object adaptResult(CompletableFuture<T> futureResult) {
            return futureResult.join();
        }
    };

    private static final Logger log;
    private static final Map<Class<?>, ResultType> METHOD_RETURN_TYPES;
    private final Class<?> returnType;

    private ResultType(Class<?> returnType) {
        this.returnType = returnType;
    }

    public static ResultType valueOf(Method method) {
        return METHOD_RETURN_TYPES.getOrDefault(method.getReturnType(), OTHER);
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public abstract <T> Object adaptResult(CompletableFuture<T> var1);

    static {
        log = LoggerFactory.getLogger(ResultType.class);
        METHOD_RETURN_TYPES = new ConcurrentHashMap();
        for (ResultType type : ResultType.values()) {
            METHOD_RETURN_TYPES.put(type.returnType, type);
        }
    }
}

