/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.domain.compatibility;

import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.IncludeExclude;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.aggregations.support.ValuesSourceParserHelper;
import org.elasticsearch.search.internal.SearchContext;

public class CompatibleTermsAggregationBuilder
extends TermsAggregationBuilder {
    public static final String NAME = "terms";
    public static final ParseField EXECUTION_HINT_FIELD_NAME = new ParseField("execution_hint", new String[0]);
    public static final ParseField SHARD_SIZE_FIELD_NAME = new ParseField("shard_size", new String[0]);
    public static final ParseField MIN_DOC_COUNT_FIELD_NAME = new ParseField("min_doc_count", new String[0]);
    public static final ParseField SHARD_MIN_DOC_COUNT_FIELD_NAME = new ParseField("shard_min_doc_count", new String[0]);
    public static final ParseField REQUIRED_SIZE_FIELD_NAME = new ParseField("size", new String[0]);
    static final TermsAggregator.BucketCountThresholds DEFAULT_BUCKET_COUNT_THRESHOLDS = new TermsAggregator.BucketCountThresholds(1L, 0L, 10, -1);
    public static final ParseField SHOW_TERM_DOC_COUNT_ERROR = new ParseField("show_term_doc_count_error", new String[0]);
    public static final ParseField ORDER_FIELD = new ParseField("order", new String[0]);
    private static final ObjectParser<TermsAggregationBuilder, Void> PARSER = new ObjectParser("terms");
    private BucketOrder order = new CompoundOrder(7, "null", false, null, Collections.singletonList(BucketOrder.count((boolean)false)));
    private IncludeExclude includeExclude = null;
    private String executionHint = null;
    private Aggregator.SubAggCollectionMode collectMode = null;
    private TermsAggregator.BucketCountThresholds bucketCountThresholds = new TermsAggregator.BucketCountThresholds(DEFAULT_BUCKET_COUNT_THRESHOLDS);
    private boolean showTermDocCountError = false;

    public static AggregationBuilder parse(String aggregationName, XContentParser parser) throws IOException {
        return (AggregationBuilder)PARSER.parse(parser, (Object)new TermsAggregationBuilder(aggregationName, null), null);
    }

    public CompatibleTermsAggregationBuilder(String name, ValueType valueType) {
        super(name, valueType);
    }

    protected CompatibleTermsAggregationBuilder(CompatibleTermsAggregationBuilder clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super((TermsAggregationBuilder)clone, factoriesBuilder, metaData);
        this.order = clone.order;
        this.executionHint = clone.executionHint;
        this.includeExclude = clone.includeExclude;
        this.collectMode = clone.collectMode;
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(clone.bucketCountThresholds);
        this.showTermDocCountError = clone.showTermDocCountError;
    }

    protected AggregationBuilder shallowCopy(AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        return new CompatibleTermsAggregationBuilder(this, factoriesBuilder, metaData);
    }

    public CompatibleTermsAggregationBuilder(StreamInput in) throws IOException {
        super(in);
        this.bucketCountThresholds = new TermsAggregator.BucketCountThresholds(in);
        this.collectMode = (Aggregator.SubAggCollectionMode)in.readOptionalWriteable(Aggregator.SubAggCollectionMode::readFromStream);
        this.executionHint = in.readOptionalString();
        this.includeExclude = (IncludeExclude)in.readOptionalWriteable(IncludeExclude::new);
        this.order = InternalOrder.Streams.readOrder((StreamInput)in);
        this.showTermDocCountError = in.readBoolean();
    }

    protected boolean serializeTargetValueType() {
        return true;
    }

    protected void innerWriteTo(StreamOutput out) throws IOException {
        this.bucketCountThresholds.writeTo(out);
        out.writeOptionalWriteable((Writeable)this.collectMode);
        out.writeOptionalString(this.executionHint);
        out.writeOptionalWriteable((Writeable)this.includeExclude);
        this.order.writeTo(out);
        out.writeBoolean(this.showTermDocCountError);
    }

    public CompatibleTermsAggregationBuilder size(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("[size] must be greater than 0. Found [" + size + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setRequiredSize(size);
        return this;
    }

    public int size() {
        return this.bucketCountThresholds.getRequiredSize();
    }

    public TermsAggregationBuilder shardSize(int shardSize) {
        if (shardSize <= 0) {
            throw new IllegalArgumentException("[shardSize] must be greater than 0. Found [" + shardSize + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardSize(shardSize);
        return this;
    }

    public int shardSize() {
        return this.bucketCountThresholds.getShardSize();
    }

    public CompatibleTermsAggregationBuilder minDocCount(long minDocCount) {
        if (minDocCount < 0L) {
            throw new IllegalArgumentException("[minDocCount] must be greater than or equal to 0. Found [" + minDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setMinDocCount(minDocCount);
        return this;
    }

    public long minDocCount() {
        return this.bucketCountThresholds.getMinDocCount();
    }

    public CompatibleTermsAggregationBuilder shardMinDocCount(long shardMinDocCount) {
        if (shardMinDocCount < 0L) {
            throw new IllegalArgumentException("[shardMinDocCount] must be greater than or equal to 0. Found [" + shardMinDocCount + "] in [" + this.name + "]");
        }
        this.bucketCountThresholds.setShardMinDocCount(shardMinDocCount);
        return this;
    }

    public long shardMinDocCount() {
        return this.bucketCountThresholds.getShardMinDocCount();
    }

    public TermsAggregationBuilder order(BucketOrder order) {
        if (order == null) {
            throw new IllegalArgumentException("[order] must not be null: [" + this.name + "]");
        }
        this.order = order instanceof InternalOrder.CompoundOrder || InternalOrder.isKeyOrder((BucketOrder)order) ? order : BucketOrder.compound((BucketOrder[])new BucketOrder[]{order});
        return this;
    }

    public CompatibleTermsAggregationBuilder order(List<BucketOrder> orders) {
        if (orders == null) {
            throw new IllegalArgumentException("[orders] must not be null: [" + this.name + "]");
        }
        this.order = new CompoundOrder(7, "null", false, null, orders);
        return this;
    }

    protected XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        this.bucketCountThresholds.toXContent(builder, params);
        builder.field(SHOW_TERM_DOC_COUNT_ERROR.getPreferredName(), this.showTermDocCountError);
        if (this.executionHint != null) {
            builder.field(TermsAggregationBuilder.EXECUTION_HINT_FIELD_NAME.getPreferredName(), this.executionHint);
        }
        builder.field(ORDER_FIELD.getPreferredName());
        this.order.toXContent(builder, params);
        if (this.collectMode != null) {
            builder.field(Aggregator.SubAggCollectionMode.KEY.getPreferredName(), this.collectMode.parseField().getPreferredName());
        }
        if (this.includeExclude != null) {
            this.includeExclude.toXContent(builder, params);
        }
        return builder;
    }

    public BucketOrder order() {
        return this.order;
    }

    public TermsAggregationBuilder executionHint(String executionHint) {
        this.executionHint = executionHint;
        return this;
    }

    public String executionHint() {
        return this.executionHint;
    }

    public TermsAggregationBuilder collectMode(Aggregator.SubAggCollectionMode collectMode) {
        if (collectMode == null) {
            throw new IllegalArgumentException("[collectMode] must not be null: [" + this.name + "]");
        }
        this.collectMode = collectMode;
        return this;
    }

    public Aggregator.SubAggCollectionMode collectMode() {
        return this.collectMode;
    }

    public TermsAggregationBuilder includeExclude(IncludeExclude includeExclude) {
        this.includeExclude = includeExclude;
        return this;
    }

    public IncludeExclude includeExclude() {
        return this.includeExclude;
    }

    public boolean showTermDocCountError() {
        return this.showTermDocCountError;
    }

    public CompatibleTermsAggregationBuilder showTermDocCountError(boolean showTermDocCountError) {
        this.showTermDocCountError = showTermDocCountError;
        return this;
    }

    protected ValuesSourceAggregatorFactory<ValuesSource, ?> innerBuild(SearchContext context, ValuesSourceConfig<ValuesSource> config, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        return null;
    }

    protected int innerHashCode() {
        return Objects.hash(this.bucketCountThresholds, this.collectMode, this.executionHint, this.includeExclude, this.order, this.showTermDocCountError);
    }

    protected boolean innerEquals(Object obj) {
        return super.innerEquals(obj);
    }

    public String getType() {
        return NAME;
    }

    static {
        ValuesSourceParserHelper.declareAnyFields(PARSER, (boolean)true, (boolean)true);
        PARSER.declareBoolean(TermsAggregationBuilder::showTermDocCountError, TermsAggregationBuilder.SHOW_TERM_DOC_COUNT_ERROR);
        PARSER.declareInt(TermsAggregationBuilder::shardSize, SHARD_SIZE_FIELD_NAME);
        PARSER.declareLong(TermsAggregationBuilder::minDocCount, MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareLong(TermsAggregationBuilder::shardMinDocCount, SHARD_MIN_DOC_COUNT_FIELD_NAME);
        PARSER.declareInt(TermsAggregationBuilder::size, REQUIRED_SIZE_FIELD_NAME);
        PARSER.declareString(TermsAggregationBuilder::executionHint, EXECUTION_HINT_FIELD_NAME);
        PARSER.declareField(TermsAggregationBuilder::collectMode, (p, c) -> Aggregator.SubAggCollectionMode.parse((String)p.text(), (DeprecationHandler)LoggingDeprecationHandler.INSTANCE), Aggregator.SubAggCollectionMode.KEY, ObjectParser.ValueType.STRING);
        PARSER.declareObjectArray(TermsAggregationBuilder::order, (p, c) -> InternalOrder.Parser.parseOrderParam((XContentParser)p), TermsAggregationBuilder.ORDER_FIELD);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge((IncludeExclude)v, (IncludeExclude)b.includeExclude())), IncludeExclude::parseInclude, IncludeExclude.INCLUDE_FIELD, ObjectParser.ValueType.OBJECT_ARRAY_OR_STRING);
        PARSER.declareField((b, v) -> b.includeExclude(IncludeExclude.merge((IncludeExclude)b.includeExclude(), (IncludeExclude)v)), IncludeExclude::parseExclude, IncludeExclude.EXCLUDE_FIELD, ObjectParser.ValueType.STRING_ARRAY);
    }

    public static class CompoundOrder
    extends InternalOrder {
        static final byte ID = -1;
        final List<BucketOrder> orderElements;

        public CompoundOrder(byte id, String key, boolean asc, Comparator<MultiBucketsAggregation.Bucket> comparator, List<BucketOrder> orderElements) {
            super(id, key, asc, comparator);
            this.orderElements = orderElements;
        }

        public List<BucketOrder> orderElements() {
            return Collections.unmodifiableList(this.orderElements);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startArray();
            for (BucketOrder order : this.orderElements) {
                order.toXContent(builder, params);
            }
            return builder.endArray();
        }
    }
}

