/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.builder.compatibility;

import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;

public class CompatibleMultiMatchQueryBuilder
extends MultiMatchQueryBuilder {
    private static final ParseField SLOP_FIELD = new ParseField("slop", new String[0]);
    private static final ParseField ZERO_TERMS_QUERY_FIELD = new ParseField("zero_terms_query", new String[0]);
    private static final ParseField LENIENT_FIELD = new ParseField("lenient", new String[0]);
    private static final ParseField CUTOFF_FREQUENCY_FIELD = new ParseField("cutoff_frequency", new String[0]);
    private static final ParseField TIE_BREAKER_FIELD = new ParseField("tie_breaker", new String[0]);
    private static final ParseField USE_DIS_MAX_FIELD = new ParseField("use_dis_max", new String[0]);
    private static final ParseField FUZZY_REWRITE_FIELD = new ParseField("fuzzy_rewrite", new String[0]);
    private static final ParseField MINIMUM_SHOULD_MATCH_FIELD = new ParseField("minimum_should_match", new String[0]);
    private static final ParseField OPERATOR_FIELD = new ParseField("operator", new String[0]);
    private static final ParseField MAX_EXPANSIONS_FIELD = new ParseField("max_expansions", new String[0]);
    private static final ParseField PREFIX_LENGTH_FIELD = new ParseField("prefix_length", new String[0]);
    private static final ParseField ANALYZER_FIELD = new ParseField("analyzer", new String[0]);
    private static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    private static final ParseField QUERY_FIELD = new ParseField("query", new String[0]);
    private static final ParseField FIELDS_FIELD = new ParseField("fields", new String[0]);

    public CompatibleMultiMatchQueryBuilder(Object value, String ... fields) {
        super(value, fields);
    }

    public CompatibleMultiMatchQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("multi_match");
        builder.field(QUERY_FIELD.getPreferredName(), this.value());
        builder.startArray(FIELDS_FIELD.getPreferredName());
        for (Map.Entry fieldEntry : this.fields().entrySet()) {
            builder.value((String)fieldEntry.getKey() + "^" + fieldEntry.getValue());
        }
        builder.endArray();
        builder.field(TYPE_FIELD.getPreferredName(), this.type().toString().toLowerCase(Locale.ENGLISH));
        builder.field(OPERATOR_FIELD.getPreferredName(), this.operator().toString());
        if (this.analyzer() != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer());
        }
        builder.field(SLOP_FIELD.getPreferredName(), this.slop());
        if (this.fuzziness() != null) {
            this.fuzziness().toXContent(builder, params);
        }
        builder.field(PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength());
        builder.field(MAX_EXPANSIONS_FIELD.getPreferredName(), this.maxExpansions());
        if (this.minimumShouldMatch() != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch());
        }
        if (this.fuzzyRewrite() != null) {
            builder.field(FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite());
        }
        if (this.useDisMax() != null) {
            builder.field(USE_DIS_MAX_FIELD.getPreferredName(), this.useDisMax());
        }
        if (this.tieBreaker() != null) {
            builder.field(TIE_BREAKER_FIELD.getPreferredName(), this.tieBreaker());
        }
        if (this.lenient()) {
            builder.field(LENIENT_FIELD.getPreferredName(), this.lenient());
        }
        if (this.cutoffFrequency() != null) {
            builder.field(CUTOFF_FREQUENCY_FIELD.getPreferredName(), this.cutoffFrequency());
        }
        builder.field(ZERO_TERMS_QUERY_FIELD.getPreferredName(), this.zeroTermsQuery().toString());
        this.printBoostAndQueryName(builder);
        builder.endObject();
    }
}

