/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.builder.compatibility;

import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.query.MatchQueryBuilder;

public class CompatibleMatchQueryBuilder
extends MatchQueryBuilder {
    public CompatibleMatchQueryBuilder(String fieldName, Object value) {
        super(fieldName, value);
    }

    public CompatibleMatchQueryBuilder(StreamInput in) throws IOException {
        super(in);
    }

    public void doXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject("match");
        builder.startObject(this.fieldName());
        builder.field(QUERY_FIELD.getPreferredName(), this.value());
        builder.field(OPERATOR_FIELD.getPreferredName(), this.operator().toString());
        if (this.analyzer() != null) {
            builder.field(ANALYZER_FIELD.getPreferredName(), this.analyzer());
        }
        if (this.fuzziness() != null) {
            this.fuzziness().toXContent(builder, params);
        }
        builder.field(PREFIX_LENGTH_FIELD.getPreferredName(), this.prefixLength());
        builder.field(MAX_EXPANSIONS_FIELD.getPreferredName(), this.maxExpansions());
        if (this.minimumShouldMatch() != null) {
            builder.field(MINIMUM_SHOULD_MATCH_FIELD.getPreferredName(), this.minimumShouldMatch());
        }
        if (this.fuzzyRewrite() != null) {
            builder.field(FUZZY_REWRITE_FIELD.getPreferredName(), this.fuzzyRewrite());
        }
        builder.field(FUZZY_TRANSPOSITIONS_FIELD.getPreferredName(), this.fuzzyTranspositions());
        builder.field(LENIENT_FIELD.getPreferredName(), this.lenient());
        builder.field(ZERO_TERMS_QUERY_FIELD.getPreferredName(), this.zeroTermsQuery().toString());
        if (this.cutoffFrequency() != null) {
            builder.field(CUTOFF_FREQUENCY_FIELD.getPreferredName(), this.cutoffFrequency());
        }
        this.printBoostAndQueryName(builder);
        builder.endObject();
        builder.endObject();
    }
}

