/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.proxy;

import io.manbang.ebatis.core.cluster.ClusterRouter;
import io.manbang.ebatis.core.exception.EbatisException;
import io.manbang.ebatis.core.mapper.IndexApi;
import io.manbang.ebatis.core.proxy.IndexApiImpl;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.concurrent.LazyInitializer;

enum MapperType {
    INDEX((Class)IndexApi.class){

        @Override
        public <T> T instance(LazyInitializer<ClusterRouter> clusterRouter) {
            return (T)IndexApiImpl.index(clusterRouter);
        }
    };

    private final Class<?> clazz;
    private static final Map<Class<?>, MapperType> OPERATE_TYPES;

    private MapperType(Class<?> clazz) {
        this.clazz = clazz;
    }

    public abstract <T> T instance(LazyInitializer<ClusterRouter> var1);

    public Class<?> getClazz() {
        return this.clazz;
    }

    static MapperType type(Class<?> clazz) {
        return Optional.ofNullable(OPERATE_TYPES.get(clazz)).orElseThrow(() -> new EbatisException(String.format("Unknown interface,name:%s", clazz.getName())));
    }

    static {
        OPERATE_TYPES = Arrays.stream(MapperType.values()).collect(Collectors.toMap(MapperType::getClazz, o -> o));
    }
}

