/*
 * Decompiled with CFR 0.152.
 */
package io.manbang.ebatis.core.meta;

import io.manbang.ebatis.core.common.MethodUtils;
import io.manbang.ebatis.core.meta.AnnotationAttribute;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

class DefaultAnnotationAttribute
implements AnnotationAttribute {
    private final Method method;
    private final Class<?> attributeType;
    private final boolean annotation;
    private final boolean enumeration;
    private final boolean array;

    DefaultAnnotationAttribute(Method method) {
        this.method = method;
        Class<?> returnType = method.getReturnType();
        this.array = returnType.isArray();
        this.attributeType = this.array ? returnType.getComponentType() : returnType;
        this.annotation = this.attributeType.isAnnotation();
        this.enumeration = this.attributeType.isEnum();
    }

    @Override
    public String getName() {
        return this.method.getName();
    }

    @Override
    public boolean isArray() {
        return this.array;
    }

    @Override
    public boolean isAnnotation() {
        return this.annotation;
    }

    @Override
    public boolean isEnum() {
        return this.enumeration;
    }

    @Override
    public Class<?> getAttributeType() {
        return this.attributeType;
    }

    @Override
    public <A> A getFirstValue(Annotation instance) {
        A value = this.getValue(instance);
        if (this.array) {
            Object[] values = (Object[])value;
            if (values != null && values.length > 0) {
                return (A)values[0];
            }
            return null;
        }
        return value;
    }

    @Override
    public <A> A getValue(Annotation instance) {
        return (A)MethodUtils.invoke(this.method, instance, new Object[0]);
    }
}

