/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkInternalList;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.CreateEventSubscriptionRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.Tag;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class CreateEventSubscriptionRequestMarshaller
implements Marshaller<Request<CreateEventSubscriptionRequest>, CreateEventSubscriptionRequest> {
    @Override
    public Request<CreateEventSubscriptionRequest> marshall(CreateEventSubscriptionRequest createEventSubscriptionRequest) {
        if (createEventSubscriptionRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateEventSubscriptionRequest> request = new DefaultRequest<CreateEventSubscriptionRequest>(createEventSubscriptionRequest, "AmazonRDS");
        request.addParameter("Action", "CreateEventSubscription");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createEventSubscriptionRequest.getSubscriptionName() != null) {
            request.addParameter("SubscriptionName", StringUtils.fromString(createEventSubscriptionRequest.getSubscriptionName()));
        }
        if (createEventSubscriptionRequest.getSnsTopicArn() != null) {
            request.addParameter("SnsTopicArn", StringUtils.fromString(createEventSubscriptionRequest.getSnsTopicArn()));
        }
        if (createEventSubscriptionRequest.getSourceType() != null) {
            request.addParameter("SourceType", StringUtils.fromString(createEventSubscriptionRequest.getSourceType()));
        }
        if (!createEventSubscriptionRequest.getEventCategories().isEmpty() || !((SdkInternalList)createEventSubscriptionRequest.getEventCategories()).isAutoConstruct()) {
            SdkInternalList eventCategoriesList = (SdkInternalList)createEventSubscriptionRequest.getEventCategories();
            int eventCategoriesListIndex = 1;
            for (String eventCategoriesListValue : eventCategoriesList) {
                if (eventCategoriesListValue != null) {
                    request.addParameter("EventCategories.EventCategory." + eventCategoriesListIndex, StringUtils.fromString(eventCategoriesListValue));
                }
                ++eventCategoriesListIndex;
            }
        }
        if (!createEventSubscriptionRequest.getSourceIds().isEmpty() || !((SdkInternalList)createEventSubscriptionRequest.getSourceIds()).isAutoConstruct()) {
            SdkInternalList sourceIdsList = (SdkInternalList)createEventSubscriptionRequest.getSourceIds();
            int sourceIdsListIndex = 1;
            for (String sourceIdsListValue : sourceIdsList) {
                if (sourceIdsListValue != null) {
                    request.addParameter("SourceIds.SourceId." + sourceIdsListIndex, StringUtils.fromString(sourceIdsListValue));
                }
                ++sourceIdsListIndex;
            }
        }
        if (createEventSubscriptionRequest.getEnabled() != null) {
            request.addParameter("Enabled", StringUtils.fromBoolean(createEventSubscriptionRequest.getEnabled()));
        }
        if (!createEventSubscriptionRequest.getTags().isEmpty() || !((SdkInternalList)createEventSubscriptionRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createEventSubscriptionRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

