/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.annotation.SdkInternalApi;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.annotation.ThreadSafe;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.auth.SessionCredentialsHolder;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkPredicate;
import java.util.Date;
import java.util.concurrent.TimeUnit;

@SdkInternalApi
@ThreadSafe
class ShouldDoAsyncSessionRefresh
extends SdkPredicate<SessionCredentialsHolder> {
    private static final long ASYNC_REFRESH_EXPIRATION_IN_MILLIS = TimeUnit.MINUTES.toMillis(5L);

    ShouldDoAsyncSessionRefresh() {
    }

    @Override
    public boolean test(SessionCredentialsHolder sessionCredentialsHolder) {
        Date expiryTime = sessionCredentialsHolder.getSessionCredentialsExpiration();
        if (expiryTime != null) {
            long timeRemaining = expiryTime.getTime() - System.currentTimeMillis();
            return timeRemaining < ASYNC_REFRESH_EXPIRATION_IN_MILLIS;
        }
        return false;
    }
}

