/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.annotation.SdkInternalApi;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.AmazonRDS;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.DescribeDBClusterSnapshotsRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.DescribeDBClusterSnapshotsResult;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.DescribeDBInstancesRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.DescribeDBInstancesResult;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.DescribeDBSnapshotsRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.DescribeDBSnapshotsResult;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DBClusterSnapshotAvailable;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DBClusterSnapshotDeleted;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DBInstanceAvailable;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DBInstanceDeleted;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DBSnapshotAvailable;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DBSnapshotDeleted;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DescribeDBClusterSnapshotsFunction;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DescribeDBInstancesFunction;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.waiters.DescribeDBSnapshotsFunction;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.waiters.FixedDelayStrategy;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.waiters.PollingStrategy;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.waiters.Waiter;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.waiters.WaiterBuilder;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.waiters.WaiterExecutorServiceFactory;
import java.util.concurrent.ExecutorService;

public class AmazonRDSWaiters {
    private final AmazonRDS client;
    private final ExecutorService executorService = WaiterExecutorServiceFactory.buildExecutorServiceForWaiter("AmazonRDSWaiters");

    @SdkInternalApi
    public AmazonRDSWaiters(AmazonRDS client) {
        this.client = client;
    }

    public Waiter<DescribeDBInstancesRequest> dBInstanceAvailable() {
        return new WaiterBuilder<DescribeDBInstancesRequest, DescribeDBInstancesResult>().withSdkFunction(new DescribeDBInstancesFunction(this.client)).withAcceptors(new DBInstanceAvailable.IsAvailableMatcher(), new DBInstanceAvailable.IsDeletedMatcher(), new DBInstanceAvailable.IsDeletingMatcher(), new DBInstanceAvailable.IsFailedMatcher(), new DBInstanceAvailable.IsIncompatiblerestoreMatcher(), new DBInstanceAvailable.IsIncompatibleparametersMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBSnapshotsRequest> dBSnapshotAvailable() {
        return new WaiterBuilder<DescribeDBSnapshotsRequest, DescribeDBSnapshotsResult>().withSdkFunction(new DescribeDBSnapshotsFunction(this.client)).withAcceptors(new DBSnapshotAvailable.IsAvailableMatcher(), new DBSnapshotAvailable.IsDeletedMatcher(), new DBSnapshotAvailable.IsDeletingMatcher(), new DBSnapshotAvailable.IsFailedMatcher(), new DBSnapshotAvailable.IsIncompatiblerestoreMatcher(), new DBSnapshotAvailable.IsIncompatibleparametersMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBSnapshotsRequest> dBSnapshotDeleted() {
        return new WaiterBuilder<DescribeDBSnapshotsRequest, DescribeDBSnapshotsResult>().withSdkFunction(new DescribeDBSnapshotsFunction(this.client)).withAcceptors(new DBSnapshotDeleted.IsTrueMatcher(), new DBSnapshotDeleted.IsDBSnapshotNotFoundMatcher(), new DBSnapshotDeleted.IsCreatingMatcher(), new DBSnapshotDeleted.IsModifyingMatcher(), new DBSnapshotDeleted.IsRebootingMatcher(), new DBSnapshotDeleted.IsResettingmastercredentialsMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBClusterSnapshotsRequest> dBClusterSnapshotAvailable() {
        return new WaiterBuilder<DescribeDBClusterSnapshotsRequest, DescribeDBClusterSnapshotsResult>().withSdkFunction(new DescribeDBClusterSnapshotsFunction(this.client)).withAcceptors(new DBClusterSnapshotAvailable.IsAvailableMatcher(), new DBClusterSnapshotAvailable.IsDeletedMatcher(), new DBClusterSnapshotAvailable.IsDeletingMatcher(), new DBClusterSnapshotAvailable.IsFailedMatcher(), new DBClusterSnapshotAvailable.IsIncompatiblerestoreMatcher(), new DBClusterSnapshotAvailable.IsIncompatibleparametersMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBClusterSnapshotsRequest> dBClusterSnapshotDeleted() {
        return new WaiterBuilder<DescribeDBClusterSnapshotsRequest, DescribeDBClusterSnapshotsResult>().withSdkFunction(new DescribeDBClusterSnapshotsFunction(this.client)).withAcceptors(new DBClusterSnapshotDeleted.IsTrueMatcher(), new DBClusterSnapshotDeleted.IsDBClusterSnapshotNotFoundFaultMatcher(), new DBClusterSnapshotDeleted.IsCreatingMatcher(), new DBClusterSnapshotDeleted.IsModifyingMatcher(), new DBClusterSnapshotDeleted.IsRebootingMatcher(), new DBClusterSnapshotDeleted.IsResettingmastercredentialsMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public Waiter<DescribeDBInstancesRequest> dBInstanceDeleted() {
        return new WaiterBuilder<DescribeDBInstancesRequest, DescribeDBInstancesResult>().withSdkFunction(new DescribeDBInstancesFunction(this.client)).withAcceptors(new DBInstanceDeleted.IsTrueMatcher(), new DBInstanceDeleted.IsDBInstanceNotFoundMatcher(), new DBInstanceDeleted.IsCreatingMatcher(), new DBInstanceDeleted.IsModifyingMatcher(), new DBInstanceDeleted.IsRebootingMatcher(), new DBInstanceDeleted.IsResettingmastercredentialsMatcher()).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(60), new FixedDelayStrategy(30))).withExecutorService(this.executorService).build();
    }

    public void shutdown() {
        this.executorService.shutdown();
    }
}

