/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkInternalList;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.ModifyDBProxyRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.UserAuthConfig;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class ModifyDBProxyRequestMarshaller
implements Marshaller<Request<ModifyDBProxyRequest>, ModifyDBProxyRequest> {
    @Override
    public Request<ModifyDBProxyRequest> marshall(ModifyDBProxyRequest modifyDBProxyRequest) {
        if (modifyDBProxyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ModifyDBProxyRequest> request = new DefaultRequest<ModifyDBProxyRequest>(modifyDBProxyRequest, "AmazonRDS");
        request.addParameter("Action", "ModifyDBProxy");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyDBProxyRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString(modifyDBProxyRequest.getDBProxyName()));
        }
        if (modifyDBProxyRequest.getNewDBProxyName() != null) {
            request.addParameter("NewDBProxyName", StringUtils.fromString(modifyDBProxyRequest.getNewDBProxyName()));
        }
        if (!modifyDBProxyRequest.getAuth().isEmpty() || !((SdkInternalList)modifyDBProxyRequest.getAuth()).isAutoConstruct()) {
            SdkInternalList authList = (SdkInternalList)modifyDBProxyRequest.getAuth();
            int authListIndex = 1;
            for (UserAuthConfig authListValue : authList) {
                if (authListValue.getDescription() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".Description", StringUtils.fromString(authListValue.getDescription()));
                }
                if (authListValue.getUserName() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".UserName", StringUtils.fromString(authListValue.getUserName()));
                }
                if (authListValue.getAuthScheme() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".AuthScheme", StringUtils.fromString(authListValue.getAuthScheme()));
                }
                if (authListValue.getSecretArn() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".SecretArn", StringUtils.fromString(authListValue.getSecretArn()));
                }
                if (authListValue.getIAMAuth() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".IAMAuth", StringUtils.fromString(authListValue.getIAMAuth()));
                }
                ++authListIndex;
            }
        }
        if (modifyDBProxyRequest.getRequireTLS() != null) {
            request.addParameter("RequireTLS", StringUtils.fromBoolean(modifyDBProxyRequest.getRequireTLS()));
        }
        if (modifyDBProxyRequest.getIdleClientTimeout() != null) {
            request.addParameter("IdleClientTimeout", StringUtils.fromInteger(modifyDBProxyRequest.getIdleClientTimeout()));
        }
        if (modifyDBProxyRequest.getDebugLogging() != null) {
            request.addParameter("DebugLogging", StringUtils.fromBoolean(modifyDBProxyRequest.getDebugLogging()));
        }
        if (modifyDBProxyRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString(modifyDBProxyRequest.getRoleArn()));
        }
        if (!modifyDBProxyRequest.getSecurityGroups().isEmpty() || !((SdkInternalList)modifyDBProxyRequest.getSecurityGroups()).isAutoConstruct()) {
            SdkInternalList securityGroupsList = (SdkInternalList)modifyDBProxyRequest.getSecurityGroups();
            int securityGroupsListIndex = 1;
            for (String securityGroupsListValue : securityGroupsList) {
                if (securityGroupsListValue != null) {
                    request.addParameter("SecurityGroups.member." + securityGroupsListIndex, StringUtils.fromString(securityGroupsListValue));
                }
                ++securityGroupsListIndex;
            }
        }
        return request;
    }
}

