/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkInternalList;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.CreateDBProxyRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.Tag;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.UserAuthConfig;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class CreateDBProxyRequestMarshaller
implements Marshaller<Request<CreateDBProxyRequest>, CreateDBProxyRequest> {
    @Override
    public Request<CreateDBProxyRequest> marshall(CreateDBProxyRequest createDBProxyRequest) {
        if (createDBProxyRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateDBProxyRequest> request = new DefaultRequest<CreateDBProxyRequest>(createDBProxyRequest, "AmazonRDS");
        request.addParameter("Action", "CreateDBProxy");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (createDBProxyRequest.getDBProxyName() != null) {
            request.addParameter("DBProxyName", StringUtils.fromString(createDBProxyRequest.getDBProxyName()));
        }
        if (createDBProxyRequest.getEngineFamily() != null) {
            request.addParameter("EngineFamily", StringUtils.fromString(createDBProxyRequest.getEngineFamily()));
        }
        if (!createDBProxyRequest.getAuth().isEmpty() || !((SdkInternalList)createDBProxyRequest.getAuth()).isAutoConstruct()) {
            SdkInternalList authList = (SdkInternalList)createDBProxyRequest.getAuth();
            int authListIndex = 1;
            for (UserAuthConfig authListValue : authList) {
                if (authListValue.getDescription() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".Description", StringUtils.fromString(authListValue.getDescription()));
                }
                if (authListValue.getUserName() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".UserName", StringUtils.fromString(authListValue.getUserName()));
                }
                if (authListValue.getAuthScheme() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".AuthScheme", StringUtils.fromString(authListValue.getAuthScheme()));
                }
                if (authListValue.getSecretArn() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".SecretArn", StringUtils.fromString(authListValue.getSecretArn()));
                }
                if (authListValue.getIAMAuth() != null) {
                    request.addParameter("Auth.member." + authListIndex + ".IAMAuth", StringUtils.fromString(authListValue.getIAMAuth()));
                }
                ++authListIndex;
            }
        }
        if (createDBProxyRequest.getRoleArn() != null) {
            request.addParameter("RoleArn", StringUtils.fromString(createDBProxyRequest.getRoleArn()));
        }
        if (!createDBProxyRequest.getVpcSubnetIds().isEmpty() || !((SdkInternalList)createDBProxyRequest.getVpcSubnetIds()).isAutoConstruct()) {
            SdkInternalList vpcSubnetIdsList = (SdkInternalList)createDBProxyRequest.getVpcSubnetIds();
            int vpcSubnetIdsListIndex = 1;
            for (String vpcSubnetIdsListValue : vpcSubnetIdsList) {
                if (vpcSubnetIdsListValue != null) {
                    request.addParameter("VpcSubnetIds.member." + vpcSubnetIdsListIndex, StringUtils.fromString(vpcSubnetIdsListValue));
                }
                ++vpcSubnetIdsListIndex;
            }
        }
        if (!createDBProxyRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)createDBProxyRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)createDBProxyRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.member." + vpcSecurityGroupIdsListIndex, StringUtils.fromString(vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (createDBProxyRequest.getRequireTLS() != null) {
            request.addParameter("RequireTLS", StringUtils.fromBoolean(createDBProxyRequest.getRequireTLS()));
        }
        if (createDBProxyRequest.getIdleClientTimeout() != null) {
            request.addParameter("IdleClientTimeout", StringUtils.fromInteger(createDBProxyRequest.getIdleClientTimeout()));
        }
        if (createDBProxyRequest.getDebugLogging() != null) {
            request.addParameter("DebugLogging", StringUtils.fromBoolean(createDBProxyRequest.getDebugLogging()));
        }
        if (!createDBProxyRequest.getTags().isEmpty() || !((SdkInternalList)createDBProxyRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)createDBProxyRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        return request;
    }
}

