/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.Certificate;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.StaxUnmarshallerContext;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class CertificateStaxUnmarshaller
implements Unmarshaller<Certificate, StaxUnmarshallerContext> {
    private static CertificateStaxUnmarshaller instance;

    @Override
    public Certificate unmarshall(StaxUnmarshallerContext context) throws Exception {
        Certificate certificate = new Certificate();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            targetDepth += 3;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return certificate;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("CertificateIdentifier", targetDepth)) {
                    certificate.setCertificateIdentifier(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CertificateType", targetDepth)) {
                    certificate.setCertificateType(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Thumbprint", targetDepth)) {
                    certificate.setThumbprint(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("ValidFrom", targetDepth)) {
                    certificate.setValidFrom(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("ValidTill", targetDepth)) {
                    certificate.setValidTill(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                    continue;
                }
                if (context.testExpression("CertificateArn", targetDepth)) {
                    certificate.setCertificateArn(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomerOverride", targetDepth)) {
                    certificate.setCustomerOverride(SimpleTypeStaxUnmarshallers.BooleanStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CustomerOverrideValidTill", targetDepth)) continue;
                certificate.setCustomerOverrideValidTill(SimpleTypeStaxUnmarshallers.DateStaxUnmarshallerFactory.getInstance("iso8601").unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return certificate;
    }

    public static CertificateStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new CertificateStaxUnmarshaller();
        }
        return instance;
    }
}

