/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.org.apache.http.impl.client;

import io.magj.iamjdbcdriver.repackaged.org.apache.http.HttpEntity;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.HttpResponse;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.StatusLine;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.annotation.Contract;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.annotation.ThreadingBehavior;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.client.HttpResponseException;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.client.ResponseHandler;
import io.magj.iamjdbcdriver.repackaged.org.apache.http.util.EntityUtils;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public abstract class AbstractResponseHandler<T>
implements ResponseHandler<T> {
    @Override
    public T handleResponse(HttpResponse response) throws HttpResponseException, IOException {
        StatusLine statusLine = response.getStatusLine();
        HttpEntity entity = response.getEntity();
        if (statusLine.getStatusCode() >= 300) {
            EntityUtils.consume(entity);
            throw new HttpResponseException(statusLine.getStatusCode(), statusLine.getReasonPhrase());
        }
        return entity == null ? null : (T)this.handleEntity(entity);
    }

    public abstract T handleEntity(HttpEntity var1) throws IOException;
}

