/*
 * Decompiled with CFR 0.152.
 */
package io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.transform;

import io.magj.iamjdbcdriver.repackaged.com.amazonaws.DefaultRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.Request;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.SdkClientException;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.http.HttpMethodName;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.internal.SdkInternalList;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.RestoreDBClusterFromSnapshotRequest;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.ScalingConfiguration;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.services.rds.model.Tag;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.transform.Marshaller;
import io.magj.iamjdbcdriver.repackaged.com.amazonaws.util.StringUtils;

public class RestoreDBClusterFromSnapshotRequestMarshaller
implements Marshaller<Request<RestoreDBClusterFromSnapshotRequest>, RestoreDBClusterFromSnapshotRequest> {
    @Override
    public Request<RestoreDBClusterFromSnapshotRequest> marshall(RestoreDBClusterFromSnapshotRequest restoreDBClusterFromSnapshotRequest) {
        ScalingConfiguration scalingConfiguration;
        if (restoreDBClusterFromSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<RestoreDBClusterFromSnapshotRequest> request = new DefaultRequest<RestoreDBClusterFromSnapshotRequest>(restoreDBClusterFromSnapshotRequest, "AmazonRDS");
        request.addParameter("Action", "RestoreDBClusterFromSnapshot");
        request.addParameter("Version", "2014-10-31");
        request.setHttpMethod(HttpMethodName.POST);
        if (!restoreDBClusterFromSnapshotRequest.getAvailabilityZones().isEmpty() || !((SdkInternalList)restoreDBClusterFromSnapshotRequest.getAvailabilityZones()).isAutoConstruct()) {
            SdkInternalList availabilityZonesList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.getAvailabilityZones();
            int availabilityZonesListIndex = 1;
            for (String availabilityZonesListValue : availabilityZonesList) {
                if (availabilityZonesListValue != null) {
                    request.addParameter("AvailabilityZones.AvailabilityZone." + availabilityZonesListIndex, StringUtils.fromString(availabilityZonesListValue));
                }
                ++availabilityZonesListIndex;
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier() != null) {
            request.addParameter("DBClusterIdentifier", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getDBClusterIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier() != null) {
            request.addParameter("SnapshotIdentifier", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getSnapshotIdentifier()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngine() != null) {
            request.addParameter("Engine", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getEngine()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEngineVersion() != null) {
            request.addParameter("EngineVersion", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getEngineVersion()));
        }
        if (restoreDBClusterFromSnapshotRequest.getPort() != null) {
            request.addParameter("Port", StringUtils.fromInteger(restoreDBClusterFromSnapshotRequest.getPort()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName() != null) {
            request.addParameter("DBSubnetGroupName", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getDBSubnetGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDatabaseName() != null) {
            request.addParameter("DatabaseName", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getDatabaseName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getOptionGroupName() != null) {
            request.addParameter("OptionGroupName", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getOptionGroupName()));
        }
        if (!restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds().isEmpty() || !((SdkInternalList)restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds()).isAutoConstruct()) {
            SdkInternalList vpcSecurityGroupIdsList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.getVpcSecurityGroupIds();
            int vpcSecurityGroupIdsListIndex = 1;
            for (String vpcSecurityGroupIdsListValue : vpcSecurityGroupIdsList) {
                if (vpcSecurityGroupIdsListValue != null) {
                    request.addParameter("VpcSecurityGroupIds.VpcSecurityGroupId." + vpcSecurityGroupIdsListIndex, StringUtils.fromString(vpcSecurityGroupIdsListValue));
                }
                ++vpcSecurityGroupIdsListIndex;
            }
        }
        if (!restoreDBClusterFromSnapshotRequest.getTags().isEmpty() || !((SdkInternalList)restoreDBClusterFromSnapshotRequest.getTags()).isAutoConstruct()) {
            SdkInternalList tagsList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.getTags();
            int tagsListIndex = 1;
            for (Tag tagsListValue : tagsList) {
                if (tagsListValue.getKey() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Key", StringUtils.fromString(tagsListValue.getKey()));
                }
                if (tagsListValue.getValue() != null) {
                    request.addParameter("Tags.Tag." + tagsListIndex + ".Value", StringUtils.fromString(tagsListValue.getValue()));
                }
                ++tagsListIndex;
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getKmsKeyId() != null) {
            request.addParameter("KmsKeyId", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getKmsKeyId()));
        }
        if (restoreDBClusterFromSnapshotRequest.getEnableIAMDatabaseAuthentication() != null) {
            request.addParameter("EnableIAMDatabaseAuthentication", StringUtils.fromBoolean(restoreDBClusterFromSnapshotRequest.getEnableIAMDatabaseAuthentication()));
        }
        if (restoreDBClusterFromSnapshotRequest.getBacktrackWindow() != null) {
            request.addParameter("BacktrackWindow", StringUtils.fromLong(restoreDBClusterFromSnapshotRequest.getBacktrackWindow()));
        }
        if (!restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports().isEmpty() || !((SdkInternalList)restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports()).isAutoConstruct()) {
            SdkInternalList enableCloudwatchLogsExportsList = (SdkInternalList)restoreDBClusterFromSnapshotRequest.getEnableCloudwatchLogsExports();
            int enableCloudwatchLogsExportsListIndex = 1;
            for (String enableCloudwatchLogsExportsListValue : enableCloudwatchLogsExportsList) {
                if (enableCloudwatchLogsExportsListValue != null) {
                    request.addParameter("EnableCloudwatchLogsExports.member." + enableCloudwatchLogsExportsListIndex, StringUtils.fromString(enableCloudwatchLogsExportsListValue));
                }
                ++enableCloudwatchLogsExportsListIndex;
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getEngineMode() != null) {
            request.addParameter("EngineMode", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getEngineMode()));
        }
        if ((scalingConfiguration = restoreDBClusterFromSnapshotRequest.getScalingConfiguration()) != null) {
            if (scalingConfiguration.getMinCapacity() != null) {
                request.addParameter("ScalingConfiguration.MinCapacity", StringUtils.fromInteger(scalingConfiguration.getMinCapacity()));
            }
            if (scalingConfiguration.getMaxCapacity() != null) {
                request.addParameter("ScalingConfiguration.MaxCapacity", StringUtils.fromInteger(scalingConfiguration.getMaxCapacity()));
            }
            if (scalingConfiguration.getAutoPause() != null) {
                request.addParameter("ScalingConfiguration.AutoPause", StringUtils.fromBoolean(scalingConfiguration.getAutoPause()));
            }
            if (scalingConfiguration.getSecondsUntilAutoPause() != null) {
                request.addParameter("ScalingConfiguration.SecondsUntilAutoPause", StringUtils.fromInteger(scalingConfiguration.getSecondsUntilAutoPause()));
            }
            if (scalingConfiguration.getTimeoutAction() != null) {
                request.addParameter("ScalingConfiguration.TimeoutAction", StringUtils.fromString(scalingConfiguration.getTimeoutAction()));
            }
        }
        if (restoreDBClusterFromSnapshotRequest.getDBClusterParameterGroupName() != null) {
            request.addParameter("DBClusterParameterGroupName", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getDBClusterParameterGroupName()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDeletionProtection() != null) {
            request.addParameter("DeletionProtection", StringUtils.fromBoolean(restoreDBClusterFromSnapshotRequest.getDeletionProtection()));
        }
        if (restoreDBClusterFromSnapshotRequest.getCopyTagsToSnapshot() != null) {
            request.addParameter("CopyTagsToSnapshot", StringUtils.fromBoolean(restoreDBClusterFromSnapshotRequest.getCopyTagsToSnapshot()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDomain() != null) {
            request.addParameter("Domain", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getDomain()));
        }
        if (restoreDBClusterFromSnapshotRequest.getDomainIAMRoleName() != null) {
            request.addParameter("DomainIAMRoleName", StringUtils.fromString(restoreDBClusterFromSnapshotRequest.getDomainIAMRoleName()));
        }
        return request;
    }
}

